angular.module('xlrelease').factory('reportOptionsService', function () {
    var ONE_MONTH = 30 * 24 * 3600 * 1000;

    var defaultOptions = {
        title: {
            text: ''
        },
        credits: {
            enabled: false
        },
        xAxis: {
            type: 'datetime',
            labels: {
                formatter: function () {
                    return moment(this.value).format("D MMMM YYYY");
                }
            },
            minTickInterval: ONE_MONTH
        },
        legend: {
            borderWidth: 0
        },
        plotOptions: {
            scatter: {
                marker: {
                    radius: 5,
                    states: {
                        hover: {
                            enabled: true,
                            lineColor: 'rgb(100,100,100)'
                        }
                    }
                },
                states: {
                    hover: {
                        marker: {
                            enabled: false
                        }
                    }
                }
            },
            spline: {
                marker: {
                    enabled: false
                },
                enableMouseTracking: false,
                lineWidth: 1
            }
        }
    };

    return {
        getHighchartsOptions: function (options) {
            return angular.extend(angular.copy(defaultOptions), options);
        }
    }
});


angular.module('xlrelease').directive('releaseDurationReport', ['durationFilter', 'reportOptionsService', function (durationFilter, reportOptionsService) {
    return function (scope, element) {
        scope.$watch('releasesDuration', function (releasesDuration) {
            if (releasesDuration) {
                element.highcharts(reportOptionsService.getHighchartsOptions({
                    yAxis: {
                        title: {
                            text: 'Duration in days'
                        },
                        min: 0
                    },
                    tooltip: {
                        hideDelay: 0,
                        formatter: function () {
                            var tooltipContent = '<b>' + this.point.name + '</b><br>';
                            tooltipContent += '<b>' + durationFilter(this.y) + '</b>';
                            return  tooltipContent;
                        }
                    },
                    series: [
                        {
                            type: 'scatter',
                            name: 'Without automation',
                            data: releasesDuration['DURATION_WITHOUT_AUTOMATION']
                        },
                        {
                            type: 'scatter',
                            name: 'With automation',
                            data: releasesDuration['DURATION_WITH_AUTOMATION']
                        },
                        {
                            type: 'spline',
                            name: 'Average',
                            data: releasesDuration['AVERAGE']
                        },
                        {
                            type: 'spline',
                            name: 'Average with automation',
                            data: releasesDuration['AVERAGE_WITH_AUTOMATION']
                        },
                        {
                            type: 'spline',
                            name: 'Average without automation',
                            data: releasesDuration['AVERAGE_WITHOUT_AUTOMATION']
                        }
                    ]
                }));
            }
        });
    }
}]);

angular.module('xlrelease').directive('releaseAutomationReport', ['reportOptionsService', function (reportOptionsService) {
    return function (scope, element) {
        scope.$watch('releasesAutomation', function (releasesAutomation) {
            if (releasesAutomation) {
                element.highcharts(reportOptionsService.getHighchartsOptions({
                    yAxis: {
                        title: {
                            text: 'Percentage'
                        },
                        min: 0,
                        max: 100
                    },
                    tooltip: {
                        hideDelay: 0,
                        formatter: function () {
                            var tooltipContent = '<b>' + this.point.name + '</b><br>';
                            tooltipContent += '<b>' + Math.round(this.y) + '% </b>';
                            return  tooltipContent;
                        }
                    },
                    series: [
                        {
                            type: 'scatter',
                            name: 'Percentage of automated tasks',
                            data: releasesAutomation['AUTOMATION_PERCENTAGE']
                        },
                        {
                            type: 'scatter',
                            name: 'Time spent in automated',
                            data: releasesAutomation['AUTOMATION_DURATION_PERCENTAGE']
                        },
                        {
                            type: 'spline',
                            name: 'Average percentage of automated tasks',
                            data: releasesAutomation['AVERAGE_AUTOMATION_PERCENTAGE']
                        },
                        {
                            type: 'spline',
                            name: 'Average time spent in automated',
                            data: releasesAutomation['AVERAGE_AUTOMATION_DURATION_PERCENTAGE']
                        }
                    ]
                }));
            }
        });
    }
}]);

angular.module('xlrelease').directive('releaseNumberReport', ['reportOptionsService', function (reportOptionsService) {
    return function (scope, element) {
        scope.$watch('numberOfReleasesPerMonth', function (numberOfReleasesPerMonth) {
            if (numberOfReleasesPerMonth) {
                var categories = _.map(_.pluck(numberOfReleasesPerMonth, 'x'), function (date) {
                    return moment(date).format("MMMM YYYY");
                });
                var data = _.pluck(numberOfReleasesPerMonth, 'y');

                element.highcharts(reportOptionsService.getHighchartsOptions({
                    tooltip: {
                        enabled: false
                    },
                    legend: {
                        enabled: false
                    },
                    xAxis: {
                        categories: categories
                    },
                    yAxis: {
                        title: {
                            text: 'Number'
                        },
                        min: 0
                    },
                    series: [
                        {
                            type: 'column',
                            name: 'Number',
                            data: data,
                            dataLabels: {
                                enabled: true,
                                color: '#FFFFFF',
                                align: 'center',
                                y: 30
                            }
                        }
                    ]
                }));
            }
        });
    }
}]);
