'use strict';

angular.module('xlrelease').factory('worksheetService', function () {
    var ANIMATION_DURATION = 300;
    return {
        computeWhichPhasesAreHighlighted: function (worksheetConfig) {
            var hiddenPartOfLeftTruncatedPhase = worksheetConfig.scrollLeft % worksheetConfig.phaseWidth;
            var phaseWidthWithoutMargin = (worksheetConfig.phaseWidth - worksheetConfig.phaseMarginLeft - worksheetConfig.phaseMarginRight);

            var firstPhaseStartVisibleOffset;
            if(hiddenPartOfLeftTruncatedPhase <= worksheetConfig.phaseMarginLeft) {
                firstPhaseStartVisibleOffset = worksheetConfig.phaseMarginLeft - hiddenPartOfLeftTruncatedPhase;
            } else {
                firstPhaseStartVisibleOffset = worksheetConfig.phaseWidth - hiddenPartOfLeftTruncatedPhase + worksheetConfig.phaseMarginLeft;
            }

            var worksheetWithEntirePhasesWidth = worksheetConfig.worksheetWidth - firstPhaseStartVisibleOffset;
            var numberOfDisplayedPhase = 0;
            if (worksheetWithEntirePhasesWidth >= phaseWidthWithoutMargin) {
                numberOfDisplayedPhase = 1 + Math.floor((worksheetWithEntirePhasesWidth - phaseWidthWithoutMargin) / worksheetConfig.phaseWidth);
            }

            var firstPhaseVisibleIndex = Math.floor(worksheetConfig.scrollLeft / worksheetConfig.phaseWidth);
            if (hiddenPartOfLeftTruncatedPhase > worksheetConfig.phaseMarginLeft) {
                firstPhaseVisibleIndex++;
            }

            return {
                firstPhaseVisibleIndex: firstPhaseVisibleIndex,
                numberOfDisplayedPhase: numberOfDisplayedPhase
            }
        },
        isAddedPhaseLast: function (newPhases, oldPhases) {
            if (newPhases.length === oldPhases.length + 1) {

                var lastNew = newPhases[newPhases.length - 1];
                var lastOld = oldPhases[oldPhases.length - 1];

                return oldPhases.length == 0 || lastNew.id !== lastOld.id;
            }

            return false;
        },
        scroll: function (element, params, callback) {
            element.animate(params, ANIMATION_DURATION, callback);
        }
    };
});
