'use strict';

angular.module('xlrelease').controller('pipelineController', ['$scope', 'Backend', 'ReleasesService', 'FlagService', 'TasksService', 'taskTypeCssClassFilter', function ($scope, Backend, ReleasesService, FlagService, TasksService, taskTypeCssClassFilter) {
    var filters = {
        active: true
    };

    Backend.get('releases', {params: filters}).success(function (releases) {
        $scope.releases = releases;
    });

    $scope.isReleaseOrSubtaskFlagged = FlagService.isReleaseOrSubtaskFlagged;

    $scope.getPhaseContentClassNames = function (phase, task) {
        var hasPhaseStatus = phase && phase.status;
        var hasTaskType = task && task.taskType;
        var hasTaskStatus = task && task.status;

        var classNames = [];

        if (hasPhaseStatus) {
            classNames.push(phase.status.toLowerCase());
        }
        if (hasPhaseStatus && phase.status === 'IN_PROGRESS' && hasTaskType &&
            (TasksService.isDeployitTask(task)|| TasksService.isGateTask(task))) {
            classNames.push(taskTypeCssClassFilter(task.taskType));
        }
        if (hasPhaseStatus && hasTaskStatus && phase.status === 'IN_PROGRESS' && TasksService.isTaskPending(task)) {
            classNames.push('pending-task');
        }


        return classNames.sort().join(' ');
    };
}]);
