/*
 * Adapted from :
 *
 *   https://github.com/tkrotoff/jquery-simplecolorpicker
 *   Copyright (C) 2012-2013 Tanguy Krotoff <tkrotoff@gmail.com>
 *
 *   Licensed under the MIT license.
 */
var app = angular.module('xlrelease');

app.value('PhaseColors', [
    { name: "Blue", value: '#009CDB' }, // Should be the same as the @defaultPhaseColor variable defined in less file
    { name: "Green", value: '#68b749' },
    { name: "Orange", value: '#ff9e3b' },
    { name: "Red", value: '#dd4b39' },
    { name: "Grey", value: '#707070' },
    { name: "Purple", value: '#663366' }
]);

app.value('DayColors', [
    { name: "None", value: '' },
    { name: "Blue", value: '#c3d4ef' },
    { name: "Green", value: '#d0efd3' },
    { name: "Orange", value: '#f7e9d4' },
    { name: "Light blue", value: '#def1f9' }
]);

app.directive('colorPickerSwatch', function () {
    return {
        templateUrl: 'partials/colorpicker/swatch.html',
        replace: true,
        scope: {
            'color'       : '=cpColor',
            'currentColor': '=cpCurrentColor'
        },
        link: function (scope, element) {
            scope.clicked = function () {
                if (element.hasClass('button')) {
                    scope.$parent.selectColor(scope.color.value);
                }
            };
        }
    };
});

app.directive('colorPicker', function () {
    var bootstrapArrowWidth = 18,
        bootstrapArrowHeight = 6;
    return {
        templateUrl: 'partials/colorpicker/main.html',
        replace: true,
        scope: {
            'colors'      : '=',
            'currentColor': '=',
            'onChange'    : '&',
            'inline'      : '='
        },
        link: function (scope, element, attrs) {
            if (!scope.currentColor) {
                scope.currentColor = scope.colors[0].value;
            }

            var picker = element.find('.simplecolorpicker');
            if (attrs.inline) {
                picker.addClass('inline');
            } else {
                picker.addClass('popup');
            }

            var toggler = element.find('.toggle-picker');
            var popup = element.find('.popup');
            var view = $('.view');

            var showPicker = function () {
                var pos = toggler.position();
                popup.css({
                    left: pos.left + toggler.width() / 2 - bootstrapArrowWidth + view.scrollLeft(),
                    top : pos.top + toggler.outerHeight() + bootstrapArrowHeight
                });
                popup.show();
            };
            var hidePicker = function () {
                popup.hide();
            };
            var togglePicker = function() {
                if (popup.is(':visible')) {
                    hidePicker();
                } else {
                    showPicker();
                }
            };
            var mouseDown = function (e) {
                e.stopPropagation();
                e.preventDefault();
            };

            $(document).on('mousedown', hidePicker);
            toggler.on('mousedown', togglePicker);
            element.on('mousedown', '.popup, .toggle-picker', mouseDown);
            element.parents('.phase-header').on('mouseleave', hidePicker);

            scope.selectColor = function (color) {
                scope.currentColor = color;
                hidePicker();
                scope.onChange( { 'color': color } );
            }
        }
    };
});
