angular.module('xlrelease').directive('displayReleaseTitle', ['FlagService', 'CalendarDisplay', 'ReleasesService', function (FlagService, CalendarDisplay, ReleasesService) {
    return {
        templateUrl: "partials/calendar/release-title.html",
        restrict: 'A',
        scope: {
            release: '=',
            releasesDependencies: '='
        },
        link: function (scope, element) {
            scope.isReleaseOrSubtaskFlagged = FlagService.isReleaseOrSubtaskFlagged;
            scope.isInConflict = function (releaseId) {
                return ReleasesService.isInConflict(releaseId, scope.releasesDependencies);
            };
            CalendarDisplay.resizeReleaseTitle(element);
        }
    }
}]);
