angular.module('xlrelease').directive('calendarTooltip', [function () {
    return {
        restrict: 'A',
        link: function (scope, tooltipElement) {
            var releaseElement = tooltipElement.parents('.release');

            releaseElement.qtip({
                content: releaseElement.find('.tooltip').contents(),
                position: {
                    my: 'bottom center',
                    at: 'top center',
                    target: 'mouse',
                    adjust: {
                        mouse: false
                    },
                    viewport: $(window)
                },
                show: 'click',
                hide: 'unfocus',
                style: 'qtip-bootstrap',
                events: {
                    toggle: function () {
                        releaseElement.parents('#days').find('.' + scope.release.id).toggleClass('release-selected');
                    }
                }
            });

            releaseElement.on("$destroy", function () {
                releaseElement.qtip("destroy", true);
            });
        }
    };
}]);

angular.module('xlrelease').directive('calendarTooltipDependency', ['FlagService', function (FlagService) {
    return {
        restrict: 'A',
        link: function (scope, element, attrs) {
            var dependency = scope[attrs.dependency];
            var type = attrs.type;
            var releaseElement = element.parents('.release');
            element.on('mouseout mouseover', function () {
                releaseElement.parents('#days').find('.' + dependency.releaseId).toggleClass(type + '-dependency-highlight');
            });
            scope.isReleaseOrSubtaskFlagged = FlagService.isReleaseOrSubtaskFlagged;
        }
    };
}]);
