'use strict';

angular.module('xlrelease').controller('calendarController', ['$route', '$scope', 'Timeout', 'Calendar', 'DateService', 'Backend', 'ReleasesService', 'VariablesInterpolator', 'DayColors', '$routeParams', '$location', 'CalendarNavigator', 'ColorService', 'SpecialDaysService', function ($route, $scope, Timeout, Calendar, DateService, Backend, ReleasesService, VariablesInterpolator, DayColors, $routeParams, $location, CalendarNavigator, ColorService, SpecialDaysService) {
    var URL_DATE_FORMAT = "MM-YYYY";

    $scope.filters = {
        active: true,
        planned: true,
        completed: false,
        onlyMine: false,
        onlyFlagged: false,
        filter: ''
    };

    $scope.DayColors = DayColors;

    $scope.currentDate = moment($routeParams.month, URL_DATE_FORMAT).date(1);

    $scope.$watchCollection('filters', loadReleases);

    $scope.showNavigator = CalendarNavigator.isNavigatorOpen();

    function loadReleases() {
        Backend.get('releases', { params: $scope.filters }).success(function (releases) {
            $scope.releases = releases;
            initCalendar($scope.currentDate);
            ReleasesService.getReleasesDependenciesByReleaseId(releases).then(function (releasesDependencies) {
                $scope.releasesDependencies = releasesDependencies;
            });
            $scope.releasesVariables = _.object(_.map(releases, function (release) {
                return [release.id, release.variables];
            }));
        });
    }

    function initCalendar(date) {
        var calendar = Calendar.init($scope.releases, date);
        $scope.weeks = calendar.weeks;
        $scope.months = calendar.months;
        $scope.currentDate = date;

        SpecialDaysService.loadCalendarSpecialDays($scope.weeks);
    }

    $scope.delayedWatch(500, 'searchFilter', function (newFilter) {
        $scope.filters.filter = newFilter;
    });

    $scope.showDate = function (date) {
        $location.search({month: date.format(URL_DATE_FORMAT)});
    };

    $scope.showToday = function () {
        $location.search({month: DateService.getToday().date(1).format(URL_DATE_FORMAT)});
    };

    $scope.showPreviousMonth = function () {
        $location.search({month: $scope.currentDate.subtract("months", 1).format(URL_DATE_FORMAT)});
    };

    $scope.showNextMonth = function () {
        $location.search({month: $scope.currentDate.add("months", 1).format(URL_DATE_FORMAT)});
    };

    $scope.isCurrentMonth = function (month) {
        return month.fullDate.month() === $scope.currentDate.month() && month.fullDate.year() === $scope.currentDate.year();
    };

    $scope.getIncomingDependencies = function (releaseId) {
        return getReleaseDependencies(releaseId, 'incomingDependencies');
    };

    $scope.getOutgoingDependencies = function (releaseId) {
        return getReleaseDependencies(releaseId, 'outgoingDependencies');
    };

    function getReleaseDependencies(releaseId, property) {
        var releaseDependencies = $scope.releasesDependencies[releaseId];
        return releaseDependencies ? releaseDependencies[property] : [];
    }

    $scope.interpolate = function (title, releaseId) {
        if (title) {
            return VariablesInterpolator.interpolateInText($scope.releasesVariables[releaseId], title);
        }
    };

    $scope.isInConflict = function (releaseId) {
        return ReleasesService.isInConflict(releaseId, $scope.releasesDependencies);
    };

    $scope.editDay = function (day) {
        $scope.editedDay = {
            label: day.label,
            color: day.color
        };
        Backend.get(SpecialDaysService.specialDayUrl(day)).success(function (serverData) {
            $scope.editedDay.label = serverData.label;
            $scope.editedDay.color = serverData.color;
        });
        $scope.editedDayDisplay = day.fullDate.format('MMMM Do');
    };

    $scope.saveDay = function (day, dismiss) {
        Backend.put(SpecialDaysService.specialDayUrl(day), { label: $scope.editedDay.label, color: $scope.editedDay.color }).success(function () {
            day.label = $scope.editedDay.label;
            day.color = $scope.editedDay.color;
            dismiss();
        });
    };

    $scope.toggleNavigator = function () {
        $scope.showNavigator = CalendarNavigator.toggleNavigator();
    };

    $scope.isReleaseCompleted = ReleasesService.isReleaseCompleted;
    $scope.downloadCalendar = ReleasesService.downloadCalendar;
    $scope.computeDayColor = ColorService.computeDayColor;
    $scope.computePhaseColor = ColorService.computePhaseColor;
}]);
