'use strict';

var xlrelease = angular.module('xlrelease', ['$strap.directives', 'ngSanitize', 'ngRoute']);

xlrelease.config(['$routeProvider', function ($routeProvider) {
    $routeProvider.
        when('/default', {template: '<div></div>', controller: 'defaultRouteController'}).

        when('/login', {templateUrl: 'partials/login/login.html', controller: 'loginController'}).
        when('/tasks', {templateUrl: 'partials/tasks/tasks.html', controller: 'tasksController'}).
        when('/pipeline', {templateUrl: 'partials/releases/pipeline.html', controller: 'pipelineController'}).

        when('/releases', {templateUrl: 'partials/releases/releases.html', controller: 'releasesController'}).
        when('/releases/create', {templateUrl: 'partials/releases/release-properties.html', controller: 'releasePropertiesController'}).
        when('/releases/:releaseId', {templateUrl: 'partials/releases/release-editor.html', controller: 'releaseEditorController'}).
        when('/releases/:releaseId/summary', {templateUrl: 'partials/releases/summary/summary.html', controller: 'releaseSummaryController',
            resolve: {
                releasePromise: ['ReleasesService', '$route', function (ReleasesService, $route) { return ReleasesService.getRelease($route.current.params.releaseId) }],
                releaseDependenciesPromise: ['ReleasesService', '$route', function (ReleasesService, $route) { return ReleasesService.getReleaseDependencies($route.current.params.releaseId) }]
            }}).
        when('/releases/:releaseId/permissions', {templateUrl: 'partials/security/permissions.html', controller: 'permissionsController'}).
        when('/releases/:releaseId/teams', {templateUrl: 'partials/releases/teams.html', controller: 'teamsController'}).
        when('/releases/:releaseId/logs', {templateUrl: 'partials/releases/logs.html', controller: 'logsController'}).
        when('/releases/:releaseId/properties', {templateUrl: 'partials/releases/release-properties.html', controller: 'releasePropertiesController'}).

        when('/templates', {templateUrl: 'partials/templates/templates.html', controller: 'templatesController'}).
        when('/templates/create', {templateUrl: 'partials/templates/template-properties.html', controller: 'templatePropertiesController'}).
        when('/templates/:releaseId', {templateUrl: 'partials/releases/release-editor.html', controller: 'releaseEditorController'}).
        when('/templates/:releaseId/permissions', {templateUrl: 'partials/security/permissions.html', controller: 'permissionsController'}).
        when('/templates/:releaseId/teams', {templateUrl: 'partials/releases/teams.html', controller: 'teamsController'}).
        when('/templates/:releaseId/logs', {templateUrl: 'partials/releases/logs.html', controller: 'logsController'}).
        when('/templates/:releaseId/properties', {templateUrl: 'partials/templates/template-properties.html', controller: 'templatePropertiesController'}).

        when('/profile', {templateUrl: 'partials/profile/profile.html', controller: 'profileController'}).
        when('/roles', {templateUrl: 'partials/security/roles.html', controller: 'rolesController'}).
        when('/permissions', {templateUrl: 'partials/security/permissions.html', controller: 'permissionsController'}).
        when('/servers', {templateUrl: 'partials/deployit/servers.html', controller: 'serversController'}).
        when('/calendar', {templateUrl: 'partials/calendar/calendar.html', controller: 'calendarController',
            resolve: { initCurrentDate: ['RouterResolver', function (RouterResolver) { return RouterResolver.initCurrentDate() }] }}).
        when('/reports', {templateUrl: 'partials/report/report.html', controller: 'reportController'}).
        when('/smtp', {templateUrl: 'partials/smtp/smtp.html', controller: 'smtpController'}).

        when('/forbidden-access/:errorMessage', {templateUrl: 'partials/forbidden-access/forbidden-access.html', controller: 'forbiddenAccessController'}).
        when('/invalid-license', {templateUrl: 'partials/licenses/invalid-license.html'}).

        otherwise({redirectTo: '/default'});
}]);

xlrelease.config(['$httpProvider', function ($httpProvider) {
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/json';
}]);
