import httplib, base64, sys, string
import com.xhaus.jyson.JysonCodec as json

ISSUE_CREATED_STATUS = 201

content = """
{
    "fields": {
       "project":
       {
          "key": "%s"
       },
       "summary": "%s",
       "description": "%s",
       "issuetype": {
          "name": "%s"
       }
   }
}
""" % (project, title, description, string.capwords(issueType))

credentials = base64.b64encode(username + ':' + password)

if jiraURL.startswith('https://'):
    jira = httplib.HTTPSConnection(jiraURL[8:])
elif jiraURL.startswith('http://'):
    jira = httplib.HTTPConnection(jiraURL[7:])
else:
    jira = httplib.HTTPConnection(jiraURL)

jira.request('POST', '/rest/api/2/issue', content, {'Authorization': 'Basic ' + credentials, 'Content-Type': 'application/json'})
response = jira.getresponse()

if response.status == ISSUE_CREATED_STATUS:
    data = json.loads(response.read())
    issueId = data.get('key')
    print "Created %s in JIRA at %s." % (issueId, jiraURL)
else:
    print "Failed to create issue in JIRA at %s." % jiraURL
    print "Status: %s" % response.status
    print "Reason: %s" % response.reason
    print "Raw error:"
    print response.read()
    sys.exit(1)
