/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAware;
import ro.isdc.wro.manager.factory.standalone.StandaloneWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupExtractorDecorator;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.processor.factory.DefaultProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;

public class DefaultStandaloneContextAwareManagerFactory
extends StandaloneWroManagerFactory
implements StandaloneContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStandaloneContextAwareManagerFactory.class);
    private StandaloneContext standaloneContext;

    public void initialize(StandaloneContext standaloneContext) {
        Validate.notNull((Object)standaloneContext);
        this.standaloneContext = standaloneContext;
        Context.get().getConfig().setIgnoreMissingResources(standaloneContext.isIgnoreMissingResources());
        LOG.debug("initialize: {}", (Object)standaloneContext);
        LOG.debug("config: {}", (Object)Context.get().getConfig());
    }

    protected GroupExtractor newGroupExtractor() {
        return new GroupExtractorDecorator(super.newGroupExtractor()){

            public boolean isMinimized(HttpServletRequest request) {
                return DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.isMinimize();
            }
        };
    }

    protected WroModelFactory newModelFactory() {
        return new XmlModelFactory(){

            protected InputStream getModelResourceAsStream() throws IOException {
                return new FileInputStream(DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.getWroFile());
            }
        };
    }

    protected ProcessorsFactory newProcessorsFactory() {
        return new DefaultProcessorsFactory();
    }

    protected ServletContextUriLocator newServletContextUriLocator() {
        return new ServletContextUriLocator(){

            public InputStream locate(String uri) throws IOException {
                if (this.getWildcardStreamLocator().hasWildcard(uri)) {
                    String fullPath = FilenameUtils.getFullPath((String)uri);
                    String realPath = DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.getContextFolder().getPath() + fullPath;
                    return this.getWildcardStreamLocator().locateStream(uri, new File(realPath));
                }
                String uriWithoutPrefix = uri.replaceFirst("/", "");
                File file = new File(DefaultStandaloneContextAwareManagerFactory.this.standaloneContext.getContextFolder(), uriWithoutPrefix);
                LOG.debug("Opening file: " + file.getPath());
                return new FileInputStream(file);
            }
        };
    }
}

