/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.TaskFullView;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class TaskViewBuilder {
    private String id;
    private String title;
    private String description;
    private String taskType;
    private TaskStatus status;
    private FlagStatus flagStatus = FlagStatus.OK;
    private String flagComment;
    private Date dueDate;
    private Date scheduledStartDate;
    private String owner;
    private String team;
    private String environment;
    private String deploymentPackage;
    private String server;
    private Set<String> addresses;
    private String subject;
    private String body;
    private Map<String, Object> inputProperties = Maps.newHashMap();
    private Map<String, String> outputProperties = Maps.newHashMap();
    private String scriptDefinitionType;

    private TaskViewBuilder() {
    }

    public static TaskViewBuilder newTaskView() {
        return new TaskViewBuilder();
    }

    public TaskViewBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public TaskViewBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public TaskViewBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public TaskViewBuilder withTaskType(String taskType) {
        this.taskType = taskType;
        return this;
    }

    public TaskViewBuilder withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    public TaskViewBuilder withFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this;
    }

    public TaskViewBuilder withFlagComment(String flagComment) {
        this.flagComment = flagComment;
        return this;
    }

    public TaskViewBuilder withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public TaskViewBuilder withScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this;
    }

    public TaskViewBuilder assignedTo(String owner) {
        this.owner = owner;
        return this;
    }

    public TaskViewBuilder withTeam(String team) {
        this.team = team;
        return this;
    }

    public TaskViewBuilder withEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public TaskViewBuilder withServer(String server) {
        this.server = server;
        return this;
    }

    public TaskViewBuilder withDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
        return this;
    }

    public TaskViewBuilder withAddresses(Set<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public TaskViewBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public TaskViewBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    public TaskViewBuilder withScriptDefinitionType(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
        return this;
    }

    public TaskViewBuilder withInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = Maps.newHashMap(inputProperties);
        return this;
    }

    public TaskViewBuilder withOutputProperties(Map<String, String> outputProperties) {
        this.outputProperties = Maps.newHashMap(outputProperties);
        return this;
    }

    public TaskFullView build() {
        TaskFullView taskView = new TaskFullView();
        taskView.setId(this.id);
        taskView.setTitle(this.title);
        taskView.setDescription(this.description);
        taskView.setTaskType(this.taskType);
        taskView.setStatus(this.status);
        taskView.setFlag(new Flag(this.flagStatus, this.flagComment));
        taskView.setDueDate(this.dueDate);
        taskView.setScheduledStartDate(this.scheduledStartDate);
        taskView.setOwner(this.owner);
        taskView.setTeam(this.team);
        taskView.setEnvironment(this.environment);
        taskView.setServer(this.server);
        taskView.setDeploymentPackage(this.deploymentPackage);
        taskView.setAddresses(this.addresses);
        taskView.setSubject(this.subject);
        taskView.setBody(this.body);
        taskView.setScriptDefinitionType(this.scriptDefinitionType);
        taskView.setInputProperties(this.inputProperties);
        taskView.setOutputProperties(this.outputProperties);
        return taskView;
    }
}

