/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.xlrelease.dependency.ConflictComputer;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.views.DependencyNode;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class ReleaseDependenciesView {
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String releaseId;
    private boolean inConflict;
    private List<DependencyNode> incomingDependencies = Lists.newArrayList();
    private List<DependencyNode> outgoingDependencies = Lists.newArrayList();

    public ReleaseDependenciesView(Release release, Collection<GateTask> incomingGates, Collection<PlanItem> outgoingTargets) {
        this.releaseId = release.getId();
        for (GateTask incomingGate : incomingGates) {
            this.incomingDependencies.add(new DependencyNode(incomingGate));
        }
        for (PlanItem outgoingTarget : outgoingTargets) {
            boolean isInConflict = ConflictComputer.hasConflict(release, outgoingTarget.getRelease());
            DependencyNode node = new DependencyNode(outgoingTarget);
            node.setInConflict(isInConflict);
            this.outgoingDependencies.add(node);
            this.inConflict = this.inConflict || isInConflict;
        }
    }

    public String getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public List<DependencyNode> getIncomingDependencies() {
        return this.incomingDependencies;
    }

    public void setIncomingDependencies(List<DependencyNode> incomingDependencies) {
        this.incomingDependencies = incomingDependencies;
    }

    public List<DependencyNode> getOutgoingDependencies() {
        return this.outgoingDependencies;
    }

    public void setOutgoingDependencies(List<DependencyNode> outgoingDependencies) {
        this.outgoingDependencies = outgoingDependencies;
    }

    public boolean isInConflict() {
        return this.inConflict;
    }

    public void setInConflict(boolean inConflict) {
        this.inConflict = inConflict;
    }
}

