/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.notification.Notifications;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.script.ScriptCallback;
import com.xebialabs.xlrelease.script.ScriptService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.DeploymentService;
import com.xebialabs.xlrelease.service.PostStartAction;
import com.xebialabs.xlrelease.user.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutionService {
    private static final int PENDING_TASKS_WATCH_INTERVAL_IN_SECONDS = 15;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionService.class);
    private Notifications notifications;
    private Comments comments;
    private Releases releases;
    private RepositoryService repositoryService;
    private Tasks tasks;
    private Scheduler scheduler;
    private ActivityLog activityLog;
    private DeploymentService deploymentService;
    private DependencyService dependencyService;
    private ScriptService scriptService;

    @Autowired
    public ExecutionService(Notifications notifications, Comments comments, Releases releases, RepositoryService repositoryService, Tasks tasks, Scheduler scheduler, ActivityLog activityLog, DeploymentService deploymentService, DependencyService dependencyService, ScriptService scriptService) {
        this.notifications = notifications;
        this.comments = comments;
        this.releases = releases;
        this.repositoryService = repositoryService;
        this.tasks = tasks;
        this.scheduler = scheduler;
        this.activityLog = activityLog;
        this.deploymentService = deploymentService;
        this.dependencyService = dependencyService;
        this.scriptService = scriptService;
    }

    @PostConstruct
    public void serverStarted() {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionService.this.reconnectDeployitTasks();
                }
                catch (Exception e) {
                    logger.error("Error during reconnecting of deployit tasks.", (Throwable)e);
                }
            }
        });
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionService.this.tryStartingPendingTasks();
                }
                catch (Exception e) {
                    logger.error("Error while starting pending tasks.", (Throwable)e);
                }
            }
        }, 0L, 15L, TimeUnit.SECONDS);
    }

    private void executePostStartActions(List<PostStartAction> postStartActions) {
        for (PostStartAction action : postStartActions) {
            action.run(this);
        }
    }

    public Release start(String releaseId) {
        Release release = (Release)this.repositoryService.read(releaseId);
        Changes changes = release.start();
        this.updateAndLog(releaseId, changes, User.AUTHENTICATED_USER);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
        return release;
    }

    public Release resume(String releaseId) {
        Release release = (Release)this.repositoryService.read(releaseId, false);
        Preconditions.checkState((boolean)release.isPaused(), (Object)"Only paused releases may be restarted");
        Changes changes = release.restart();
        this.updateAndLog(releaseId, changes, User.AUTHENTICATED_USER);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
        return release;
    }

    public void startPendingTask(String taskId, String addedComment) {
        Release release = this.releases.containingTask(taskId);
        this.startPendingTask(taskId, release, addedComment, User.AUTHENTICATED_USER);
    }

    private void startPendingTask(String taskId, Release release, String comment, User user) {
        Changes changes = release.startPendingTask(taskId);
        changes.addComment(taskId, comment);
        this.updateAndLog(release.getId(), changes, user);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
    }

    public void notifyTaskStarted(Task task) {
        this.notifications.notifyTaskStarted(task);
    }

    public void labelLastRevisionAsUnstarted(Task task) {
        this.tasks.labelLastRevisionAsUnstarted(task.getId());
    }

    public void markTaskAsDone(TaskStatus status, String taskId, String addedComment) {
        this.markTaskAsDone(status, taskId, addedComment, User.AUTHENTICATED_USER);
    }

    private void markTaskAsDone(TaskStatus targetStatus, String taskId, String addedComment, User user) {
        Release release = this.releases.containingTask(taskId);
        Changes changes = release.markTaskAsDone(taskId, targetStatus);
        changes.addComment(taskId, addedComment);
        this.updateAndLog(release.getId(), changes, user);
        this.executePostStartActions(changes.getPostStartActions());
        this.completeDependentGates(changes);
    }

    public void fail(String taskId, String addedComment) {
        this.fail(taskId, addedComment, User.AUTHENTICATED_USER);
    }

    private void fail(String taskId, String addedComment, User user) {
        Release release = this.releases.containingTask(taskId);
        Changes changes = new Changes();
        changes.addAll(release.failTask(taskId, addedComment));
        this.updateAndLog(release.getId(), changes, user);
        this.notifications.notifyTaskFailed(release, this.tasks.findById(taskId));
    }

    public Release abort(String releaseId) {
        Release release = (Release)this.repositoryService.read(releaseId);
        Changes changes = release.abort();
        this.updateAndLog(releaseId, changes, User.AUTHENTICATED_USER);
        this.failDependentGates(changes, release.getTitle());
        return release;
    }

    public void retry(String taskId, String addedComment) {
        Release release = this.releases.containingTask(taskId);
        Changes changes = release.retryTask(taskId);
        changes.addComment(taskId, addedComment);
        this.updateAndLog(release.getId(), changes, User.AUTHENTICATED_USER);
        this.executePostStartActions(changes.getPostStartActions());
    }

    private void completeDependentGates(Changes changes) {
        Collection<GateTask> completableGates = this.dependencyService.getCompletableGates(this.toPlanItems(changes.getUpdatedItems()));
        for (final GateTask gate : completableGates) {
            this.scheduler.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ReleaseLock.of(gate);
                    synchronized (object) {
                        try {
                            ExecutionService.this.markTaskAsDone(TaskStatus.COMPLETED, gate.getId(), null, User.SYSTEM);
                        }
                        catch (Exception e) {
                            logger.error("Error while completing dependent gate " + gate.getId(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private void failDependentGates(Changes changes, final String releaseTitle) {
        Collection<GateTask> failableGates = this.dependencyService.getFailableGates(this.toPlanItems(changes.getUpdatedItems()));
        for (final GateTask gate : failableGates) {
            this.scheduler.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ReleaseLock.of(gate);
                    synchronized (object) {
                        try {
                            ExecutionService.this.fail(gate.getId(), FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(releaseTitle), User.SYSTEM);
                        }
                        catch (Exception e) {
                            logger.error("Error while failing dependent gate " + gate.getId(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private Set<PlanItem> toPlanItems(Set<ConfigurationItem> updatedItems) {
        HashSet<PlanItem> planItems = new HashSet<PlanItem>();
        for (ConfigurationItem updatedItem : updatedItems) {
            if (!(updatedItem instanceof PlanItem)) continue;
            planItems.add((PlanItem)updatedItem);
        }
        return planItems;
    }

    private void updateAndLog(String releaseId, Changes changes, User user) {
        this.repositoryService.update(changes.toUpdatedItemsArray());
        this.activityLog.log(releaseId, changes.getActivityLogEntries(), user);
        for (Map.Entry entry : changes.getCommentsByTaskId().entries()) {
            String addedComment = (String)entry.getValue();
            this.comments.create((String)entry.getKey(), addedComment, user, false);
        }
    }

    @VisibleForTesting
    void reconnectDeployitTasks() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(DeployitTask.class)).addProperty("status", TaskStatus.IN_PROGRESS.name());
        List tasks = this.repositoryService.listEntities(query);
        for (DeployitTask task : tasks) {
            logger.info("Reconnecting deployit task '{}'", (Object)task.getId());
            this.deploy(task);
        }
    }

    public void deploy(final DeployitTask task) {
        Runnable onSuccess = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReleaseLock.of(task);
                synchronized (object) {
                    logger.info("Deployment task '{}' successfully executed.", (Object)task.getId());
                    ExecutionService.this.markTaskAsDone(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
                }
            }
        };
        Runnable onFailure = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReleaseLock.of(task);
                synchronized (object) {
                    logger.info("Deployment task '{}' failed.", (Object)task.getId());
                    ExecutionService.this.fail(task.getId(), FailureReasons.DEPLOYMENT_TASK_FAILED.format(new Object[0]), User.SYSTEM);
                }
                ExecutionService.this.deploymentService.rollbackAsynchronously(task.getId());
            }
        };
        Runnable onException = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReleaseLock.of(task);
                synchronized (object) {
                    ExecutionService.this.fail(task.getId(), FailureReasons.DEPLOYMENT_TASK_FAILED.format(new Object[0]), User.SYSTEM);
                }
            }
        };
        this.deploymentService.deployAsynchronously(task, onSuccess, onFailure, onException);
    }

    public void sendNotification(final NotificationTask task) {
        Runnable onSuccess = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReleaseLock.of(task);
                synchronized (object) {
                    ExecutionService.this.markTaskAsDone(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
                }
            }
        };
        Runnable onException = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReleaseLock.of(task);
                synchronized (object) {
                    ExecutionService.this.fail(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[0]), User.SYSTEM);
                }
            }
        };
        this.notifications.executeNotificationTask(task, onSuccess, onException);
    }

    public void executeScript(ScriptTask task) {
        this.scriptService.executeScriptTask(task, this.getOnSuccessScriptCallBack(task), this.getOnFailureScriptCallBack(task));
    }

    public void executeCustomScript(CustomScriptTask task) {
        this.scriptService.executeCustomScriptTask(task, this.getOnSuccessScriptCallBack(task), this.getOnFailureScriptCallBack(task));
    }

    private ScriptCallback getOnSuccessScriptCallBack(final Task task) {
        return new ScriptCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReleaseLock.of(task);
                synchronized (object) {
                    ExecutionService.this.markTaskAsDone(TaskStatus.COMPLETED, task.getId(), this.getExecutionLog(), User.SYSTEM);
                }
            }
        };
    }

    private ScriptCallback getOnFailureScriptCallBack(final Task task) {
        return new ScriptCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ReleaseLock.of(task);
                synchronized (object) {
                    ExecutionService.this.fail(task.getId(), FailureReasons.SCRIPT_TASK_FAILED.format(this.getExecutionLog()), User.SYSTEM);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void tryStartingPendingTasks() {
        List<Task> pendingTasks = this.tasks.findPendingTasks();
        for (Task task : pendingTasks) {
            if (!task.canStartNow()) continue;
            Object object = ReleaseLock.of(task);
            synchronized (object) {
                this.startPendingTask(task.getId(), task.getRelease(), null, User.SYSTEM);
            }
        }
    }
}

