/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plumbing.remote.DeployitConnection;
import com.xebialabs.deployit.plumbing.remote.DeployitConnectionFactory;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.configuration.DeployitServerDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeployitService {
    private final DeployitConnectionFactory connections;
    private final Scheduler scheduler;
    public static final int ALL_SERVERS_TIMEOUT_SECONDS = 30;
    private static final Logger logger = LoggerFactory.getLogger(DeployitService.class);

    @Autowired
    public DeployitService(DeployitConnectionFactory connections, Scheduler scheduler) {
        this.connections = connections;
        this.scheduler = scheduler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkConnection(DeployitServerDefinition deployitServer) {
        try (DeployitConnection deployit = this.connect(deployitServer);){
            deployit.getMetadataService().listPermissions();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info("Could not check the connection to Deployit server at {}. {}", (Object)deployitServer, (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ConfigurationItemId> getPackagesIds(DeployitServerDefinition deployitServer) {
        try (DeployitConnection deployit = this.connect(deployitServer);){
            List list = deployit.getRepositoryService().query(Type.valueOf(DeploymentPackage.class), null, null, null, null, -1L, -1L);
            return list;
        }
        catch (Exception e) {
            logger.info("Could not get packages from Deployit server at {}. {}", (Object)deployitServer, (Object)e);
            return Lists.newArrayList();
        }
    }

    public List<ConfigurationItemId> getPackagesIds(List<DeployitServerDefinition> deployitServers) throws InterruptedException {
        ArrayList futures = Lists.newArrayList();
        for (final DeployitServerDefinition server : deployitServers) {
            futures.add(this.scheduler.submit(new Callable<List<ConfigurationItemId>>(){

                @Override
                public List<ConfigurationItemId> call() throws Exception {
                    return DeployitService.this.getPackagesIds(server);
                }
            }));
        }
        return this.aggregateResults(futures, deployitServers, "Could not get packages from Deployit servers");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ConfigurationItemId> getEnvironmentsIds(DeployitServerDefinition deployitServer) {
        try (DeployitConnection deployit = this.connect(deployitServer);){
            List list = deployit.getRepositoryService().query(Type.valueOf(Environment.class), null, null, null, null, -1L, -1L);
            return list;
        }
        catch (Exception e) {
            logger.info("Could not get environments from Deployit server at {}. {}", (Object)deployitServer, (Object)e);
            return Lists.newArrayList();
        }
    }

    public List<ConfigurationItemId> getEnvironmentsIds(List<DeployitServerDefinition> deployitServers) throws InterruptedException {
        ArrayList futures = Lists.newArrayList();
        for (final DeployitServerDefinition server : deployitServers) {
            futures.add(this.scheduler.submit(new Callable<List<ConfigurationItemId>>(){

                @Override
                public List<ConfigurationItemId> call() throws Exception {
                    return DeployitService.this.getEnvironmentsIds(server);
                }
            }));
        }
        return this.aggregateResults(futures, deployitServers, "Could not get environments from Deployit servers");
    }

    private DeployitConnection connect(DeployitServerDefinition deployitServer) {
        return this.connections.connect(deployitServer.getBooterConfig());
    }

    private List<ConfigurationItemId> aggregateResults(List<ListenableFuture<List<ConfigurationItemId>>> futures, List<DeployitServerDefinition> deployitServers, String errorMessage) throws InterruptedException {
        try {
            ListenableFuture resultsFuture = Futures.allAsList(futures);
            List lists = (List)resultsFuture.get(30L, TimeUnit.SECONDS);
            Iterable ids = Iterables.concat((Iterable)lists);
            return this.filterDuplicates(ids);
        }
        catch (ExecutionException | TimeoutException e) {
            logger.info(errorMessage + " {}. {}", deployitServers, (Object)e);
            return Lists.newArrayList();
        }
    }

    private List<ConfigurationItemId> filterDuplicates(Iterable<ConfigurationItemId> ids) {
        TreeMap map = Maps.newTreeMap();
        for (ConfigurationItemId id : ids) {
            if (map.containsKey(id.getId())) continue;
            map.put(id.getId(), id);
        }
        return Lists.newArrayList(map.values());
    }
}

