/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.reports.Duration;
import com.xebialabs.xlrelease.reports.PhaseDuration;
import com.xebialabs.xlrelease.reports.ReleaseDuration;
import com.xebialabs.xlrelease.reports.ReportTimeFrame;
import com.xebialabs.xlrelease.reports.TaskDuration;
import com.xebialabs.xlrelease.reports.TaskWithReleaseData;
import com.xebialabs.xlrelease.reports.UserTask;
import com.xebialabs.xlrelease.repository.JcrPredicate;
import com.xebialabs.xlrelease.repository.JcrQueryBuilder;
import com.xebialabs.xlrelease.repository.JcrQueryExecutorForList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Reports {
    private JcrTemplate jcrTemplate;

    @Autowired
    public Reports(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public List<ReleaseDuration> getReleasesDuration(ReportTimeFrame since) {
        List<ReleaseDuration> releasesDuration = this.getCompletedReleases(since);
        this.computeAutomations(releasesDuration);
        return releasesDuration;
    }

    public List<UserTask> getUsersTasks(ReportTimeFrame since) {
        return new JcrQueryExecutorForList<UserTask>(this.jcrTemplate, since){

            @Override
            public String query(ReportTimeFrame since) {
                return JcrQueryBuilder.select("owner", "title", "startDate", "endDate").from("task").where(JcrPredicate.and(JcrPredicate.as("task", Task.class), JcrPredicate.equal("task.status", TaskStatus.COMPLETED.name()), JcrPredicate.greaterThan("task.endDate", since))).toString();
            }

            @Override
            public UserTask transform(Row row) throws RepositoryException {
                return new UserTask(row.getValue("owner").getString(), row.getValue("startDate").getDate(), row.getValue("endDate").getDate());
            }
        }.getList();
    }

    public List<TaskDuration> getTasksDuration(ReportTimeFrame since) {
        return new JcrQueryExecutorForList<TaskDuration>(this.jcrTemplate, since){

            @Override
            public String query(ReportTimeFrame since) {
                return JcrQueryBuilder.select("task.owner", "task.title", "task.startDate", "task.endDate", "task.team", "phase.title", "release.title").from("task").joinWithParent("task", "phase").joinWithParent("phase", "release").where(JcrPredicate.and(JcrPredicate.notNull("release.title"), JcrPredicate.as("task", Task.class), JcrPredicate.equal("task.status", TaskStatus.COMPLETED.name()), JcrPredicate.greaterThan("task.endDate", since))).toString();
            }

            @Override
            public TaskDuration transform(Row row) throws RepositoryException {
                DateTime startDate = new DateTime((Object)row.getValue("task.startDate").getDate().getTime());
                DateTime endDate = new DateTime((Object)row.getValue("task.endDate").getDate().getTime());
                TaskDuration taskDuration = new TaskDuration();
                taskDuration.setDuration(new Duration(startDate, endDate).compute());
                taskDuration.setOwner(row.getValue("task.owner").getString());
                taskDuration.setTeam(row.getValue("task.team").getString());
                taskDuration.setTitle(row.getValue("task.title").getString());
                taskDuration.setPhase(row.getValue("phase.title").getString());
                taskDuration.setRelease(row.getValue("release.title").getString());
                return taskDuration;
            }
        }.getList();
    }

    public List<TaskWithReleaseData> getTasksWithReleaseData(ReportTimeFrame since) {
        return new JcrQueryExecutorForList<TaskWithReleaseData>(this.jcrTemplate, since){

            @Override
            public String query(ReportTimeFrame since) {
                return JcrQueryBuilder.select("task.title", "task.startDate", "task.endDate", "release.title", "release.endDate", "release.title", "release.status").selectTypeAs("task", "taskType").from("task").joinWithParent("task", "release").where(JcrPredicate.and(JcrPredicate.as("task", Task.class), JcrPredicate.as("release", Release.class), JcrPredicate.equal("release.status", ReleaseStatus.COMPLETED.name()), JcrPredicate.greaterThan("task.endDate", since))).orderBy("release.endDate").toString();
            }

            @Override
            public TaskWithReleaseData transform(Row row) throws RepositoryException {
                TaskWithReleaseData task = new TaskWithReleaseData();
                task.setTitle(row.getValue("task.title").getString());
                task.setAutomated(Type.valueOf(DeployitTask.class).toString().equals(row.getValue("taskType").getString()));
                task.setStartDate(row.getValue("task.startDate").getDate());
                task.setEndDate(row.getValue("task.endDate").getDate());
                task.setReleaseId(row.getPath("release"));
                task.setReleaseTitle(row.getValue("release.title").getString());
                task.setReleaseEndDate(row.getValue("release.endDate").getDate());
                return task;
            }
        }.getList();
    }

    public List<PhaseDuration> getPhasesDuration(ReportTimeFrame since) {
        return new JcrQueryExecutorForList<PhaseDuration>(this.jcrTemplate, since){

            @Override
            public String query(ReportTimeFrame since) {
                return JcrQueryBuilder.select("phase.title", "phase.startDate", "phase.endDate", "release.title").from("phase").joinWithParent("phase", "release").where(JcrPredicate.and(JcrPredicate.as("phase", Phase.class), JcrPredicate.equal("phase.status", PhaseStatus.COMPLETED.name()), JcrPredicate.notNull("release.title"), JcrPredicate.greaterThan("phase.endDate", since))).toString();
            }

            @Override
            public PhaseDuration transform(Row row) throws RepositoryException {
                PhaseDuration phase = new PhaseDuration();
                phase.setTitle(row.getValue("phase.title").getString());
                phase.setRelease(row.getValue("release.title").getString());
                DateTime startDate = new DateTime((Object)row.getValue("phase.startDate").getDate().getTime());
                DateTime endDate = new DateTime((Object)row.getValue("phase.endDate").getDate().getTime());
                phase.setDuration(new Duration(startDate, endDate).compute());
                return phase;
            }
        }.getList();
    }

    public List<DateTime> getReleasesEndDate(ReportTimeFrame since) {
        return new JcrQueryExecutorForList<DateTime>(this.jcrTemplate, since){

            @Override
            public String query(ReportTimeFrame since) {
                return JcrQueryBuilder.select("endDate").from("release").where(JcrPredicate.and(JcrPredicate.equal("release.status", ReleaseStatus.COMPLETED.name()), JcrPredicate.as("release", Release.class), JcrPredicate.greaterThan("endDate", since))).orderBy("endDate").toString();
            }

            @Override
            public DateTime transform(Row row) throws RepositoryException {
                return new DateTime((Object)row.getValue("endDate").getDate().getTime());
            }
        }.getList();
    }

    private List<ReleaseDuration> getCompletedReleases(ReportTimeFrame since) {
        return new JcrQueryExecutorForList<ReleaseDuration>(this.jcrTemplate, since){

            @Override
            public String query(ReportTimeFrame since) {
                return JcrQueryBuilder.select("title", "startDate", "endDate").from("release").where(JcrPredicate.and(JcrPredicate.as("release", Release.class), JcrPredicate.equal("release.status", ReleaseStatus.COMPLETED.name()), JcrPredicate.greaterThan("release.endDate", since))).orderBy("endDate").toString();
            }

            @Override
            public ReleaseDuration transform(Row row) throws RepositoryException {
                ReleaseDuration releaseDuration = new ReleaseDuration();
                releaseDuration.setReleaseId(row.getPath());
                releaseDuration.setTitle(row.getValue("title").getString());
                DateTime startDate = new DateTime((Object)row.getValue("startDate").getDate().getTime());
                DateTime endDate = new DateTime((Object)row.getValue("endDate").getDate().getTime());
                releaseDuration.setDuration(new Duration(startDate, endDate).compute());
                releaseDuration.setEndDate(endDate);
                return releaseDuration;
            }
        }.getList();
    }

    private void computeAutomations(List<ReleaseDuration> releasesDuration) {
        for (ReleaseDuration releaseDuration : releasesDuration) {
            releaseDuration.setWithAutomation(this.hasAutomatedTask(releaseDuration.getReleaseId()));
        }
    }

    private boolean hasAutomatedTask(final String releaseId) {
        return (Boolean)this.jcrTemplate.execute((JcrCallback)new JcrCallback<Boolean>(){

            public Boolean doInJcr(Session session) throws RepositoryException {
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query query = qm.createQuery(this.buildQuery(), "JCR-SQL2");
                QueryResult queryResult = query.execute();
                RowIterator rows = queryResult.getRows();
                return rows.hasNext();
            }

            private String buildQuery() {
                return JcrQueryBuilder.select("title").from("task").where(JcrPredicate.and(JcrPredicate.isInPath("task", releaseId), JcrPredicate.as("task", DeployitTask.class))).toString();
            }
        });
    }
}

