/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.activity.PhaseFieldsComparator;
import com.xebialabs.xlrelease.builder.PhaseBuilder;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.repository.AbstractRepository;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.PhaseForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Phases
extends AbstractRepository {
    private ActivityLog activityLog;
    private static final String DEFAULT_TITLE = "New Phase";

    @Autowired
    public Phases(RepositoryService repositoryService, ActivityLog activityLog) {
        super(repositoryService);
        this.activityLog = activityLog;
    }

    @Override
    protected String getEntityPrefix() {
        return "Phase";
    }

    public Phase create(String parentId) {
        return this.create(parentId, DEFAULT_TITLE);
    }

    public Phase create(String parentId, String phaseTitle) {
        Release release = (Release)this.repositoryService.read(parentId);
        Preconditions.checkArgument((!release.isDefunct() ? 1 : 0) != 0, (Object)"Can't add phase to a defunct release");
        Phase newPhase = PhaseBuilder.newPhase().withId(this.getUniqueId(parentId)).withTitle(phaseTitle).withStatus(PhaseStatus.PLANNED).build();
        this.repositoryService.create((ConfigurationItem[])new Phase[]{newPhase});
        this.activityLog.log(parentId, ReleaseActivities.PHASE_CREATED.create(phaseTitle));
        return newPhase;
    }

    public Phase findById(String phaseId) {
        return (Phase)this.repositoryService.read(phaseId);
    }

    public void delete(String phaseId) {
        Phase phase = (Phase)this.repositoryService.read(phaseId);
        Preconditions.checkArgument((boolean)phase.isPlanned(), (Object)"Only planned phase can be deleted");
        this.repositoryService.delete(new String[]{phaseId});
        this.activityLog.log(Ids.releaseIdFrom(phaseId), ReleaseActivities.PHASE_DELETED.create(phase.getTitle()));
    }

    public Phase update(String phaseId, PhaseForm phaseForm) {
        Phase phase = (Phase)this.repositoryService.read(phaseId);
        Preconditions.checkArgument((!phase.isDefunct() ? 1 : 0) != 0, (Object)"Can't edit defunct phase");
        List<ActivityLogEntry> logEntries = new PhaseFieldsComparator(phase, phaseForm).getLogs();
        if (phaseForm.getTitle() != null) {
            Preconditions.checkArgument((!phaseForm.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Phase title is mandatory");
            phase.setTitle(phaseForm.getTitle());
        }
        phase.setDescription(phaseForm.getDescription());
        phase.setColor(phaseForm.getColor());
        phase.setDueDate(phaseForm.getDueDate());
        phase.setScheduledStartDate(phaseForm.getScheduledStartDate());
        this.repositoryService.update((ConfigurationItem[])new Phase[]{phase});
        this.activityLog.log(Ids.releaseIdFrom(phaseId), logEntries, User.AUTHENTICATED_USER);
        return phase;
    }
}

