/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrQueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.configuration.SpecialDay;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Calendar {
    private RepositoryService repositoryService;
    protected static final String ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Calendar";

    @Autowired
    public Calendar(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public SpecialDay getSpecialDay(String date) {
        String id = Calendar.makeId(date);
        if (!this.repositoryService.exists(id)) {
            SpecialDay result = new SpecialDay();
            result.setId(id);
            return result;
        }
        return (SpecialDay)this.repositoryService.read(id);
    }

    public SpecialDay setSpecialDay(String date, SpecialDay specialDay) {
        String id = Calendar.makeId(date);
        if (specialDay.isBlank()) {
            if (this.repositoryService.exists(id)) {
                this.repositoryService.delete(new String[]{id});
            }
        } else {
            this.createRootDirectoryIfNeeded();
            specialDay.setId(id);
            specialDay.setDate(date);
            this.repositoryService.createOrUpdate((ConfigurationItem[])new SpecialDay[]{specialDay});
        }
        return specialDay;
    }

    private void createRootDirectoryIfNeeded() {
        if (!this.repositoryService.exists(ROOT)) {
            Directory directory = new Directory();
            directory.setId(ROOT);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
    }

    public List<SpecialDay> getSpecialDays(String from, String to) {
        String request = String.format("SELECT ci.* from [deployit:configurationItem] AS ci WHERE ci.[$configuration.item.type] = '%s'   AND ci.date >= $from   AND ci.date <= $to", Type.valueOf(SpecialDay.class).toString());
        ImmutableMap parameters = ImmutableMap.of((Object)"from", (Object)from, (Object)"to", (Object)to);
        return this.repositoryService.listEntities(new JcrQueryTemplate(request, (Map)parameters));
    }

    private static String makeId(String date) {
        return ROOT + "/" + date;
    }
}

