/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.domain.Release;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Variable
implements Comparable<Variable> {
    public static final String VARIABLE_PATTERN = "\\$\\{[^}]+\\}";
    public static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("\\$\\{[^}]+\\}");
    public static final Pattern ONLY_ONE_VARIABLE_NAME_PATTERN = Pattern.compile("^\\$\\{[^}]+\\}$");
    private String key;
    private String value;
    private VariableType type;
    private boolean used;

    public Variable() {
    }

    public Variable(String key, String value) {
        this.key = key;
        this.value = value;
        this.type = VariableType.DEFAULT;
        this.used = false;
    }

    public Variable(String key, VariableType variableType) {
        this.key = key;
        this.value = "";
        this.type = variableType;
        this.used = true;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public VariableType getType() {
        return this.type;
    }

    public boolean isUsed() {
        return this.used;
    }

    public static Map<String, String> listToMap(List<Variable> list) {
        TreeMap map = Maps.newTreeMap();
        if (list != null) {
            for (Variable variable : list) {
                map.put(variable.getKey(), variable.getValue());
            }
        }
        return map;
    }

    public static List<Variable> mapToList(Map<String, String> map) {
        ArrayList result = Lists.newArrayList();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.add(new Variable(entry.getKey(), entry.getValue()));
            }
        }
        return result;
    }

    public static List<Variable> getVariables(Release release) {
        Set<Variable> variableReferences = release.collectVariableReferences();
        Map<String, String> values = release.getVariableValues();
        for (Variable variable : variableReferences) {
            if (values == null || !values.containsKey(variable.getKey())) continue;
            variable.setValue(Strings.emptyToNull((String)values.get(variable.getKey())));
        }
        Sets.SetView unusedVariables = Sets.difference((Set)Sets.newHashSet(Variable.mapToList(values)), variableReferences);
        variableReferences.addAll((Collection<Variable>)unusedVariables);
        return Lists.newArrayList(variableReferences);
    }

    public static Set<String> collectVariables(String input) {
        HashSet result = Sets.newHashSet();
        Matcher matcher = VARIABLE_NAME_PATTERN.matcher(input);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static String freezeUnresolvedVariable(String input, String variableName) {
        if (!VARIABLE_NAME_PATTERN.matcher(variableName).find()) {
            return input;
        }
        String dollarLessName = variableName.substring(1);
        return input.replace(variableName, "$~" + dollarLessName);
    }

    public static boolean containOnlyVariable(String input) {
        return ONLY_ONE_VARIABLE_NAME_PATTERN.matcher(input).find();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Variable)) {
            return false;
        }
        Variable that = (Variable)other;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(Variable that) {
        return this.key.compareTo(that.key);
    }

    public static enum VariableType {
        DEFAULT,
        DEPLOYIT_PACKAGE,
        DEPLOYIT_ENVIRONMENT,
        SCRIPT_RESULT;

    }
}

