/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaskFilter {
    private boolean active;
    private boolean assignedToMe;
    private boolean assignedToMyTeams;
    private boolean assignedToOthers;
    private boolean notAssigned;
    private String search;

    public TaskFilter(boolean active, boolean assignedToMe, boolean assignedToMyTeams, boolean assignedToOthers, boolean notAssigned, String search) {
        this.active = active;
        this.assignedToMe = assignedToMe;
        this.assignedToMyTeams = assignedToMyTeams;
        this.assignedToOthers = assignedToOthers;
        this.notAssigned = notAssigned;
        this.search = search;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAssignedToMe() {
        return this.assignedToMe;
    }

    public boolean isAssignedToMyTeams() {
        return this.assignedToMyTeams;
    }

    public boolean isAssignedToOthers() {
        return this.assignedToOthers;
    }

    public boolean isNotAssigned() {
        return this.notAssigned;
    }

    public String getSearch() {
        return this.search;
    }

    public List<Task> filter(String username, List<Release> releases) {
        ArrayList tasks = Lists.newArrayList();
        for (Release release : releases) {
            List<String> teams = release.getTeamsOf(username);
            tasks.addAll(this.filter(username, teams, release.getAllTasks()));
        }
        return tasks;
    }

    @VisibleForTesting
    List<Task> filter(String username, List<String> teams, List<Task> tasks) {
        Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"Username must not be null");
        Predicate matchesAssignment = Predicates.or((Predicate[])new Predicate[]{this.isAssignedToUserPredicate(username), this.isAssignedToTeamsPredicate(teams), this.isAssignedToOthersPredicate(username, teams), this.isNotAssignedPredicate()});
        Predicate matchesSearchQuery = Predicates.or((Predicate[])new Predicate[]{this.matchesTitle(), this.matchesOwner(), this.matchesTeam(), this.matchesRelease()});
        return Lists.newArrayList((Iterable)Collections2.filter(tasks, (Predicate)Predicates.and((Predicate[])new Predicate[]{Predicates.not((Predicate)Predicates.instanceOf(ParallelGroup.class)), this.isActivePredicate(), matchesAssignment, matchesSearchQuery})));
    }

    private Predicate<Task> isActivePredicate() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.isActive() ? task.isActive() : !task.isDone();
            }
        };
    }

    private Predicate<Task> isAssignedToUserPredicate(final String username) {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.isAssignedToMe() ? username.equals(task.getOwner()) : false;
            }
        };
    }

    private Predicate<Task> isAssignedToTeamsPredicate(final List<String> teams) {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.isAssignedToMyTeams() ? teams.contains(task.getTeam()) : false;
            }
        };
    }

    private Predicate<Task> isAssignedToOthersPredicate(final String username, final List<String> teams) {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                boolean hasDifferentTeam;
                boolean hasAssignment = task.hasOwner() || task.hasTeam();
                boolean hasDifferentOwner = !task.hasOwner() || !username.equals(task.getOwner());
                boolean bl = hasDifferentTeam = !task.hasTeam() || !teams.contains(task.getTeam());
                return TaskFilter.this.isAssignedToOthers() ? hasAssignment && hasDifferentOwner && hasDifferentTeam : false;
            }
        };
    }

    private Predicate<Task> isNotAssignedPredicate() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.isNotAssigned() ? !task.hasOwner() && !task.hasTeam() : false;
            }
        };
    }

    private Predicate<Task> matchesTitle() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getTitle());
            }
        };
    }

    private Predicate<Task> matchesOwner() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getOwner());
            }
        };
    }

    private Predicate<Task> matchesTeam() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getTeam());
            }
        };
    }

    private Predicate<Task> matchesRelease() {
        return new Predicate<Task>(){

            public boolean apply(Task task) {
                return TaskFilter.this.matchesText(task, task.getRelease().getTitle());
            }
        };
    }

    private boolean matchesText(Task task, String text) {
        if (Strings.isNullOrEmpty((String)this.search)) {
            return true;
        }
        Map<String, String> variables = task.getRelease().getVariableValues();
        String interpolatedText = Strings.nullToEmpty((String)task.replaceAll(text, variables, Sets.newHashSet(), false));
        return interpolatedText.toLowerCase().contains(this.getSearch().toLowerCase());
    }
}

