/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.PostStartAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ScriptTask
extends Task {
    @Property
    private String script;

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        visitor.visit(this);
    }

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        this.script = this.replaceAll(this.script, variables, unresolvedVariables, freezeEvenIfUnresolved);
        return unresolvedVariables;
    }

    @Override
    protected Changes execute(String targetId, ReleaseActivities activity) {
        Changes changes = super.execute(targetId, activity);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        changes.addPostStartAction(new PostStartAction(){

            @Override
            public void run(ExecutionService executionService) {
                executionService.executeScript(ScriptTask.this);
            }
        });
        return changes;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }
}

