/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.calendar.ReleaseCalendar;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.domain.VariableCollectingVisitor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

@Metadata(description="A Release.", root=Metadata.ConfigurationItemRoot.APPLICATIONS)
public class Release
extends PlanItem
implements Securable {
    @Property(asContainment=true, required=false)
    protected List<Phase> phases = Lists.newArrayList();
    @Property(asContainment=true, required=false)
    protected List<Team> teams = Lists.newArrayList();
    @Property(asContainment=true, required=false)
    private Map<String, String> variableValues = Maps.newHashMap();
    @Property
    private ReleaseStatus status;
    @Property(asContainment=true, required=false)
    private List<ActivityLogEntry> activityLogEntries = Lists.newArrayList();
    @Property(required=false)
    private List<String> tags;
    @Property(required=false)
    private String calendarLinkToken;
    @Property(required=false)
    private boolean calendarPublished;
    private static final Predicate<Phase> IS_PLANNED = new Predicate<Phase>(){

        public boolean apply(Phase phase) {
            return phase.isPlanned();
        }
    };

    public List<Phase> getPhases() {
        return this.phases;
    }

    public void setPhases(List<Phase> phases) {
        this.phases = phases;
    }

    public Map<String, String> getVariableValues() {
        return this.variableValues;
    }

    public void setVariableValues(Map<String, String> variableValues) {
        this.variableValues = variableValues;
    }

    public void addVariableValues(Map<String, String> variableValues) {
        this.variableValues.putAll(variableValues);
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReleaseStatus value) {
        this.status = value;
    }

    public List<Team> getTeams() {
        return this.teams;
    }

    public void setTeams(List<Team> teams) {
        this.teams = teams;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getCalendarLinkToken() {
        return this.calendarLinkToken;
    }

    public void setCalendarLinkToken(String calendarLinkToken) {
        this.calendarLinkToken = calendarLinkToken;
    }

    public boolean isCalendarPublished() {
        return this.calendarPublished;
    }

    public void setCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
    }

    public List<ActivityLogEntry> getActivityLogEntries() {
        return this.activityLogEntries;
    }

    public void setActivityLogEntries(List<ActivityLogEntry> activityLogEntries) {
        this.activityLogEntries = activityLogEntries;
    }

    public Phase getCurrentPhase() {
        return (Phase)((Object)Iterables.find(this.getPhases(), (Predicate)new Predicate<Phase>(){

            public boolean apply(Phase phase) {
                return phase.getStatus() == PhaseStatus.IN_PROGRESS || phase.isFailing() || phase.isFailed();
            }
        }, null));
    }

    public Task getCurrentTask() {
        Phase currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            return currentPhase.getCurrentTask();
        }
        return null;
    }

    public boolean hasCurrentPhase() {
        return null != this.getCurrentPhase();
    }

    @VisibleForTesting
    void complete() {
        this.setStatus(ReleaseStatus.COMPLETED);
        this.setEndDate(new Date());
        this.setFlagStatus(FlagStatus.OK);
        this.setFlagComment("");
        this.freezeVariables();
    }

    public Changes start() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.IN_PROGRESS);
        this.setStartDate(new Date());
        changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_STARTED.create(new Object[0]));
        if (this.hasPhase()) {
            Phase firstPhase = this.getPhases().get(0);
            changes.addAll(this.startActivablePhase(firstPhase));
        } else {
            this.complete();
            changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_COMPLETED.create(new Object[0]));
        }
        return changes;
    }

    public Changes restart() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.IN_PROGRESS);
        this.setStartDate(new Date());
        changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_RESTARTED.create(new Object[0]));
        Phase firstPlannedPhase = (Phase)((Object)Iterables.find(this.getPhases(), IS_PLANNED));
        changes.addAll(this.startActivablePhase(firstPlannedPhase));
        return changes;
    }

    private boolean hasPhase() {
        return !this.getPhases().isEmpty();
    }

    private Changes startActivablePhase(Phase phase) {
        Changes changes = new Changes();
        changes.addAll(phase.start());
        changes.addAll(this.checkPhaseStatus(phase));
        return changes;
    }

    private Changes checkPhaseStatus(Phase phase) {
        Changes changes = new Changes();
        if (phase.isDone()) {
            changes.addAll(this.startNextPhase(phase));
        } else if (phase.isFailed()) {
            changes.addAll(this.fail());
        } else if (phase.isFailing()) {
            changes.addAll(this.failing());
        }
        return changes;
    }

    private Changes startNextPhase(Phase phase) {
        Changes changes = new Changes();
        if (this.hasNextPhase(phase)) {
            Phase nextPhase = this.getNextPhase(phase);
            changes.addAll(this.startActivablePhase(nextPhase));
        } else {
            this.complete();
            changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_COMPLETED.create(new Object[0]));
        }
        return changes;
    }

    public Changes markTaskAsDone(String taskId, TaskStatus status) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            changes.addAll(this.recoverReleaseIfNeeded());
            changes.addAll(currentPhase.markTaskAsDone(taskId, status));
            changes.addAll(this.checkPhaseStatus(currentPhase));
        }
        return changes;
    }

    private Changes recoverReleaseIfNeeded() {
        Changes changes = new Changes();
        if (this.getStatus() == ReleaseStatus.FAILED || this.getStatus() == ReleaseStatus.FAILING) {
            changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_RESTARTED.create(new Object[0]));
            this.setStatus(ReleaseStatus.IN_PROGRESS);
        }
        return changes;
    }

    public Changes startPendingTask(String taskId) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            changes.addAll(currentPhase.startPendingTask(taskId));
            changes.addAll(this.checkPhaseStatus(currentPhase));
        }
        return changes;
    }

    public Changes failTask(String taskId, String failReason) {
        Changes changes = new Changes();
        for (Phase phase : this.phases) {
            Changes updatedPhaseItems = phase.failTask(taskId, failReason);
            if (!updatedPhaseItems.hasUpdatedItems()) continue;
            changes.addAll(updatedPhaseItems);
            if (phase.isFailed()) {
                changes.addAll(this.fail());
                continue;
            }
            if (!phase.isFailing()) continue;
            changes.addAll(this.failing());
        }
        return changes;
    }

    private Changes fail() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.FAILED);
        changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_FAILED.create(new Object[0]));
        return changes;
    }

    private Changes failing() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.FAILING);
        changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_FAILING.create(new Object[0]));
        return changes;
    }

    public Changes abort() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.ABORTED);
        changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_ABORTED.create(new Object[0]));
        for (Phase phase : this.phases) {
            if (phase.isDone()) continue;
            changes.addAll(phase.abort());
        }
        return changes;
    }

    public Changes retryTask(String taskId) {
        Changes changes = new Changes();
        for (Phase phase : this.phases) {
            Changes updatedPhaseItems = phase.retryTask(taskId);
            if (!updatedPhaseItems.hasUpdatedItems()) continue;
            this.setStatus(ReleaseStatus.IN_PROGRESS);
            this.setStartDate(new Date());
            changes.addAll(updatedPhaseItems);
            changes.update((ConfigurationItem)this, ReleaseActivities.RELEASE_RESTARTED.create(new Object[0]));
        }
        return changes;
    }

    public Phase getNextPhase(Phase currentPhase) {
        int currentPhasePosition = this.phases.indexOf((Object)currentPhase) + 1;
        ListIterator<Phase> iterator = this.phases.listIterator(currentPhasePosition);
        return iterator.hasNext() ? iterator.next() : null;
    }

    public boolean hasNextPhase(Phase phase) {
        return this.getNextPhase(phase) != null;
    }

    public void addPhase(Phase phase) {
        this.phases.add(phase);
    }

    @Override
    public List<Task> getAllTasks() {
        ArrayList tasks = Lists.newArrayList();
        for (Phase phase : this.phases) {
            tasks.addAll(phase.getAllTasks());
        }
        return tasks;
    }

    public List<String> getTeamsOf(String username) {
        ArrayList userTeams = Lists.newArrayList();
        for (Team team : this.teams) {
            if (!team.hasMember(username)) continue;
            userTeams.add(team.getTeamName());
        }
        return userTeams;
    }

    public Phase movePhase(Integer originIndex, Integer targetIndex) {
        Phase phaseToMove = this.phases.get(originIndex);
        Phase targetPhase = this.phases.get(targetIndex);
        Preconditions.checkArgument((phaseToMove.isPlanned() && targetPhase.isPlanned() ? 1 : 0) != 0, (Object)"Only planned phases can be moved");
        this.phases.remove((Object)phaseToMove);
        this.phases.add(targetIndex, phaseToMove);
        return phaseToMove;
    }

    public Phase getPhase(Integer index) {
        return this.phases.get(index);
    }

    public Phase getPhase(final String phaseId) {
        return (Phase)((Object)Iterables.find(this.getPhases(), (Predicate)new Predicate<Phase>(){

            public boolean apply(Phase phase) {
                return Objects.equal((Object)phase.getId(), (Object)phaseId);
            }
        }, null));
    }

    public boolean hasPhase(String phaseId) {
        return this.getPhase(phaseId) != null;
    }

    public void addTeam(Team team) {
        this.teams.add(team);
    }

    public void deleteTeam(String teamId) {
        Iterator<Team> i = this.teams.iterator();
        while (i.hasNext()) {
            Team team = i.next();
            if (!team.getId().equals(teamId)) continue;
            i.remove();
        }
    }

    public void addBelow(String phaseId, Phase addedPhase) {
        this.addBelow(phaseId, Lists.newArrayList((Object[])new Phase[]{addedPhase}));
    }

    public void addBelow(String phaseId, List<Phase> phasesToAdd) {
        for (int i = 0; i < this.getPhases().size(); ++i) {
            Phase phase = this.getPhase(i);
            if (!phase.getId().equals(phaseId)) continue;
            this.phases.addAll(i + 1, phasesToAdd);
        }
    }

    public Set<Variable> collectVariableReferences() {
        VariableCollectingVisitor visitor = new VariableCollectingVisitor();
        this.accept(visitor);
        return visitor.result();
    }

    public List<GateTask> getAllGates() {
        List<Task> allTasks = this.getAllTasks();
        return new ArrayList<GateTask>(Collections2.filter(allTasks, (Predicate)Predicates.instanceOf(GateTask.class)));
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
        for (Phase phase : this.phases) {
            phase.accept(visitor);
        }
    }

    @Override
    public boolean isDone() {
        return this.status == ReleaseStatus.COMPLETED;
    }

    @Override
    public boolean isDefunct() {
        return this.isAborted() || this.isDone();
    }

    @Override
    public boolean isAborted() {
        return this.status == ReleaseStatus.ABORTED;
    }

    public boolean isFailing() {
        return this.status == ReleaseStatus.FAILING;
    }

    public boolean isFailed() {
        return this.status == ReleaseStatus.FAILED;
    }

    public boolean isPaused() {
        return this.status == ReleaseStatus.PAUSED;
    }

    public boolean isTemplate() {
        return this.status == ReleaseStatus.TEMPLATE;
    }

    @Override
    public Release getRelease() {
        return this;
    }

    @Override
    public String getDisplayPath() {
        return this.getTitle();
    }

    public boolean hasPermission(final String user, final String permission) {
        return FluentIterable.from(this.teams).anyMatch((Predicate)new Predicate<Team>(){

            public boolean apply(Team team) {
                return team.hasMember(user) && team.hasPermission(permission);
            }
        });
    }

    public boolean hasPermission(String user, Permission permission) {
        return this.hasPermission(user, permission.getPermissionName());
    }

    public Set<String> getPermissions(String user) {
        HashSet permissions = Sets.newHashSet();
        for (Team team : this.teams) {
            if (!team.hasMember(user)) continue;
            permissions.addAll(team.getPermissions());
        }
        return permissions;
    }

    public Team getTeamWithId(String id) {
        for (Team team : this.teams) {
            if (!team.getId().equals(id)) continue;
            return team;
        }
        throw new IllegalStateException("Release " + this.getId() + " doesn't contain team with id " + id);
    }

    public String toICS() {
        return new ReleaseCalendar(this).toString();
    }

    @Override
    public boolean isFlagged() {
        if (super.isFlagged()) {
            return true;
        }
        for (Task task : this.getAllTasks()) {
            if (!task.isFlagged()) continue;
            return true;
        }
        return false;
    }

    public List<PlanItem> getOutgoingDependencies() {
        ArrayList targets = Lists.newArrayList();
        for (GateTask gate : this.getAllGates()) {
            targets.addAll(gate.getNotDoneTargets());
        }
        return targets;
    }

    public List<PlanItem> getAllPlanItems() {
        ArrayList planItems = Lists.newArrayList();
        planItems.add(this);
        planItems.addAll(this.phases);
        planItems.addAll(this.getAllTasks());
        return planItems;
    }

    private void freezeVariables() {
        if (this.variableValues == null || this.variableValues.isEmpty()) {
            return;
        }
        this.setDescription(this.replaceAll(this.getDescription(), this.variableValues, Sets.newHashSet(), false));
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("status", (Object)this.getStatus()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Release release = (Release)((Object)o);
        return this.status == release.status;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }
}

