/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.PostStartAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DeployitTask
extends Task {
    @Property(required=false)
    private String server;
    @Property(required=false)
    private String environment;
    @Property(required=false)
    private String deploymentPackage;
    @Property(required=false)
    private int currentStep;
    @Property(required=false)
    private int totalStep;
    @Property(required=false)
    private String currentStepTitle;
    @Property(required=false)
    private String deployitTaskId;
    @Property(required=false, password=true)
    private String password;
    @Property(required=false)
    private String username;

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getDeploymentPackage() {
        return this.deploymentPackage;
    }

    public void setDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
    }

    public Integer getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(Integer currentStep) {
        this.currentStep = currentStep;
    }

    public Integer getTotalStep() {
        return this.totalStep;
    }

    public void setTotalStep(Integer totalStep) {
        this.totalStep = totalStep;
    }

    public String getCurrentStepTitle() {
        return this.currentStepTitle;
    }

    public void setCurrentStepTitle(String currentStepTitle) {
        this.currentStepTitle = currentStepTitle;
    }

    public String getDeployitTaskId() {
        return this.deployitTaskId;
    }

    public void setDeployitTaskId(String deployitTaskId) {
        this.deployitTaskId = deployitTaskId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean hasCredentials() {
        return !Strings.isNullOrEmpty((String)this.username) && !Strings.isNullOrEmpty((String)this.password);
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        visitor.visit(this);
    }

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        this.setEnvironment(this.replaceAll(this.getEnvironment(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setDeploymentPackage(this.replaceAll(this.getDeploymentPackage(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setUsername(this.replaceAll(this.getUsername(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        return unresolvedVariables;
    }

    @Override
    protected Changes execute(String targetId, ReleaseActivities activity) {
        Changes changes = super.execute(targetId, activity);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        changes.addPostStartAction(new PostStartAction(){

            @Override
            public void run(ExecutionService executionService) {
                executionService.deploy(DeployitTask.this);
            }
        });
        return changes;
    }
}

