/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Variable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ReleaseBuilder {
    private String id;
    private String title;
    private String description;
    private ReleaseStatus status;
    private List<Phase> phases;
    private Date scheduledStartDate;
    private Date dueDate;
    private Date startDate;
    private Date endDate;
    private List<Team> teams;
    private String owner;
    private List<ActivityLogEntry> activityLogEntries;
    private Map<String, String> variableValues = Maps.newHashMap();
    private List<String> tags;
    private FlagStatus flagStatus = FlagStatus.OK;
    private String flagComment;
    private String calendarToken;
    private boolean calendarPublished;

    private ReleaseBuilder() {
    }

    public static ReleaseBuilder newRelease() {
        return new ReleaseBuilder();
    }

    public static Variable newVariable(String key, String value) {
        return new Variable(key, value);
    }

    public ReleaseBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public ReleaseBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public ReleaseBuilder withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this;
    }

    public ReleaseBuilder withStatus(ReleaseStatus status) {
        this.status = status;
        return this;
    }

    public ReleaseBuilder withPhases(Phase ... phases) {
        this.phases = Lists.newArrayList((Object[])phases);
        return this;
    }

    public ReleaseBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public ReleaseBuilder withScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
        return this;
    }

    public ReleaseBuilder withDueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public ReleaseBuilder withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public ReleaseBuilder withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public ReleaseBuilder withTeams(Team ... teams) {
        this.teams = Lists.newArrayList((Object[])teams);
        return this;
    }

    public ReleaseBuilder withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public ReleaseBuilder withActivityLogEntries(ActivityLogEntry ... activityLogEntries) {
        this.activityLogEntries = Lists.newArrayList((Object[])activityLogEntries);
        return this;
    }

    public ReleaseBuilder withVariableValues(List<Variable> variables) {
        this.variableValues = Variable.listToMap(variables);
        return this;
    }

    public ReleaseBuilder withVariableValues(Variable ... variables) {
        return this.withVariableValues(Lists.newArrayList((Object[])variables));
    }

    public ReleaseBuilder withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ReleaseBuilder withTags(String ... tags) {
        return this.withTags(Lists.newArrayList((Object[])tags));
    }

    public ReleaseBuilder withFlagStatus(FlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this;
    }

    public ReleaseBuilder withFlagComment(String flagComment) {
        this.flagComment = flagComment;
        return this;
    }

    public ReleaseBuilder withCalendarToken(String calendarToken) {
        this.calendarToken = calendarToken;
        return this;
    }

    public ReleaseBuilder withCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
        return this;
    }

    public Release build() {
        Release release = (Release)new Release().getType().getDescriptor().newInstance(this.id);
        release.setStatus(this.status);
        release.setTitle(this.title);
        release.setDescription(this.description);
        release.setScheduledStartDate(this.scheduledStartDate);
        release.setDueDate(this.dueDate);
        release.setStartDate(this.startDate);
        release.setEndDate(this.endDate);
        release.setTags(this.tags);
        release.setFlagStatus(this.flagStatus);
        release.setFlagComment(this.flagComment);
        release.setCalendarLinkToken(this.calendarToken);
        release.setCalendarPublished(this.calendarPublished);
        if (null != this.teams) {
            release.setTeams(this.teams);
        }
        if (null != this.phases) {
            for (Phase phase : this.phases) {
                phase.setRelease(release);
            }
            release.setPhases(this.phases);
        }
        release.setOwner(this.owner);
        if (null != this.activityLogEntries) {
            release.setActivityLogEntries(this.activityLogEntries);
        }
        release.setVariableValues(this.variableValues);
        return release;
    }
}

