/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.xlrelease.Environment;
import java.io.File;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.lesscss.LessCompiler;
import org.lesscss.LessException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.util.InMemoryResource;
import org.springframework.stereotype.Controller;

@Path(value="/")
@Controller
public class XLReleaseResource {
    private final Environment environment;

    public XLReleaseResource() {
        this.environment = new Environment();
    }

    @VisibleForTesting
    public XLReleaseResource(Environment environment) {
        this.environment = environment;
    }

    @GET
    @NoCache
    @Produces(value={"text/html;charset=UTF-8"})
    public Response redirectToRoot() throws IOException {
        return this.getRoot("index.html");
    }

    @GET
    @Path(value="{path : .*\\.html}")
    @NoCache
    @Produces(value={"text/html;charset=UTF-8"})
    public Response getRoot(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.otf}")
    @Produces(value={"font/opentype"})
    public Response getOtfFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.ico}")
    @Produces(value={"image/vnd.microsoft.icon"})
    public Response getIco(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.eot}")
    @Produces(value={"application/vnd.ms-fontobject"})
    public Response getEotFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.woff}")
    @Produces(value={"application/font-woff"})
    public Response getWoffFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.ttf}")
    @Produces(value={"application/x-font-ttf"})
    public Response getTtfFont(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.svg}")
    @Produces(value={"image/svg+xml"})
    public Response getSvg(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.css}")
    @NoCache
    @Produces(value={"text/css"})
    public Response getCss(@PathParam(value="path") String path) throws IOException, LessException {
        Resource cssFile = this.resource(path);
        Resource lessFile = this.resource(path.replaceAll("css$", "less"));
        if (lessFile.exists()) {
            boolean overrideCssIfOlder = false;
            new LessCompiler().compile(lessFile.getFile(), new File(this.environment.getWebPath(), path), overrideCssIfOlder);
            cssFile = this.resource(path);
        }
        if (cssFile.exists()) {
            return Response.ok((Object)cssFile.getInputStream()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{path : .*\\.png}")
    @Produces(value={"image/png"})
    public Response getPng(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    @GET
    @Path(value="{path : .*\\.gif}")
    @Produces(value={"image/png"})
    public Response getGif(@PathParam(value="path") String path) throws IOException {
        return this.stream(path);
    }

    private Response stream(String path) throws IOException {
        Resource resource = this.resource(path);
        if (!resource.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)resource.getInputStream()).build();
    }

    private Resource resource(String path) throws IOException {
        File file = new File(this.environment.getWebPath(), path);
        if (file.exists()) {
            if (!file.getCanonicalPath().startsWith(this.environment.getWebPath().getCanonicalPath())) {
                return new InMemoryResource("404"){

                    public boolean exists() {
                        return false;
                    }
                };
            }
            return new FileSystemResource(file);
        }
        return new ClassPathResource(path);
    }
}

