/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.deployit.plumbing.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.PhaseForm;
import com.xebialabs.xlrelease.views.PhaseFullView;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/phases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class PhaseResource {
    private Phases phases;
    private PermissionChecker permissionChecker;

    @Autowired
    public PhaseResource(Phases phases, PermissionChecker permissionChecker) {
        this.phases = phases;
        this.permissionChecker = permissionChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{phaseId}")
    public PhaseFullView update(@PathParam(value="phaseId") @IdParam String phaseId, PhaseForm phaseForm) {
        Object object = ReleaseLock.of(phaseId);
        synchronized (object) {
            this.permissionChecker.checkEdit(Ids.releaseIdFrom(phaseId));
            Phase phase = this.phases.update(phaseId, phaseForm);
            return new PhaseFullView(phase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{phaseId}")
    public void deletePhase(@PathParam(value="phaseId") @IdParam String phaseId) {
        Object object = ReleaseLock.of(phaseId);
        synchronized (object) {
            this.permissionChecker.checkEdit(Ids.releaseIdFrom(phaseId));
            this.phases.delete(phaseId);
        }
    }
}

