/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Dependencies;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.ReleaseDependenciesFullView;
import com.xebialabs.xlrelease.views.ReleaseDependenciesView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/dependencies")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class DependencyResource {
    private Tasks tasks;
    private Dependencies dependencies;
    private PermissionChecker permissions;
    private DependencyService dependencyService;
    private Releases releases;

    @Autowired
    public DependencyResource(Tasks tasks, Dependencies dependencies, PermissionChecker permissions, DependencyService dependencyService, Releases releases) {
        this.tasks = tasks;
        this.dependencies = dependencies;
        this.permissions = permissions;
        this.dependencyService = dependencyService;
        this.releases = releases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{dependencyId}")
    public DependencyView updateDependency(@PathParam(value="dependencyId") @IdParam String dependencyId, DependencyView dependencyView) {
        Object object = ReleaseLock.of(dependencyId);
        synchronized (object) {
            this.permissions.checkEditTask(Ids.releaseIdFrom(dependencyId));
            Dependency dependency = this.dependencies.update(dependencyId, dependencyView.toTargetId());
            return new DependencyView(dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{dependencyId}")
    public void deleteDependency(@PathParam(value="dependencyId") @IdParam String dependencyId) {
        Object object = ReleaseLock.of(dependencyId);
        synchronized (object) {
            this.permissions.checkEditTask(Ids.releaseIdFrom(dependencyId));
            Task task = this.tasks.findById(Ids.getParentId(dependencyId));
            Preconditions.checkArgument((!task.isStarted() ? 1 : 0) != 0, (Object)"Can't delete a dependency on a running task");
            this.dependencies.delete(dependencyId);
        }
    }

    @GET
    public List<ReleaseDependenciesView> getReleasesDependencies(@QueryParam(value="releaseId") @IdParam List<String> releaseIds) {
        this.permissions.check(XLReleasePermissions.VIEW_RELEASE, releaseIds);
        ArrayList dependencies = Lists.newArrayList();
        for (String releaseId : releaseIds) {
            Release release = this.releases.findById(releaseId);
            Collection<GateTask> incomingDependencies = this.dependencyService.findIncomingDependencies(release);
            List<PlanItem> outgoingDependencies = release.getOutgoingDependencies();
            dependencies.add(new ReleaseDependenciesView(release, incomingDependencies, outgoingDependencies));
        }
        return dependencies;
    }

    @GET
    @Path(value="{releaseId}")
    public ReleaseDependenciesFullView getReleaseDependencies(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.VIEW_RELEASE, releaseId);
        Release release = this.releases.findById(releaseId);
        Collection<GateTask> incomingDependencies = this.dependencyService.findIncomingDependencies(release);
        List<PlanItem> outgoingDependencies = release.getOutgoingDependencies();
        return new ReleaseDependenciesFullView(release, incomingDependencies, outgoingDependencies);
    }
}

