/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Calendar;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.views.SpecialDayView;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/calendar")
@Controller
public class CalendarResource {
    private static final String ICS_CONTENT_TYPE = "text/calendar";
    private static final String ICS_EXTENSION = ".ics";
    private final Cache<String, Download> downloadCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private Releases releases;
    private Calendar calendar;

    @Autowired
    public CalendarResource(Releases releases, Calendar calendar) {
        this.releases = releases;
        this.calendar = calendar;
    }

    @GET
    @Path(value="/download/{downloadkey}")
    @Produces(value={"application/octet-stream"})
    public Response download(@PathParam(value="downloadkey") String downloadKey) {
        final Download download = (Download)this.downloadCache.getIfPresent((Object)downloadKey);
        if (download == null) {
            throw new NotFoundException("The download with key [%s] was not found.", new Object[]{downloadKey});
        }
        this.downloadCache.invalidate((Object)downloadKey);
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                output.write(download.content.getBytes("UTF-8"));
            }
        };
        return Response.ok((Object)output, (String)ICS_CONTENT_TYPE).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", download.fileName)).build();
    }

    @GET
    @Path(value="/subscribe/{calendarToken}")
    public Response subscribe(@PathParam(value="calendarToken") String calendarToken) {
        Release release = this.releases.findByCalendarToken(calendarToken);
        if (release == null || !release.isCalendarPublished()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String ics = release.toICS();
        return Response.ok((Object)ics).build();
    }

    @GET
    @Path(value="/specialDays/{date}")
    public SpecialDayView getSpecialDay(@PathParam(value="date") String date) {
        return new SpecialDayView(this.calendar.getSpecialDay(date));
    }

    @PUT
    @Path(value="/specialDays/{date}")
    public SpecialDayView setSpecialDay(@PathParam(value="date") String date, SpecialDayView specialDay) {
        return new SpecialDayView(this.calendar.setSpecialDay(date, specialDay.toCi()));
    }

    @GET
    @Path(value="/specialDays")
    public List<SpecialDayView> getSpecialDays(@QueryParam(value="from") String from, @QueryParam(value="to") String to) {
        return Lists.transform(this.calendar.getSpecialDays(from, to), SpecialDayView.TO_VIEW);
    }

    public String register(String releaseId) {
        Release release = this.releases.findById(releaseId);
        String fileName = release.getTitle() + ICS_EXTENSION;
        String calendarContent = release.toICS();
        Download download = new Download(calendarContent, fileName);
        this.downloadCache.put((Object)download.key, (Object)download);
        return download.key;
    }

    private static class Download {
        private final String key = UUID.randomUUID().toString();
        private final String content;
        private final String fileName;

        Download(String content, String fileName) {
            this.content = content;
            this.fileName = fileName;
        }
    }
}

