/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Joiner;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.Team;
import java.util.List;

public class PermissionsLogFormatter {
    private Multimap<String, String> teamToPermissions = TreeMultimap.create();
    private static final Joiner.MapJoiner WITH_ARROWS = Joiner.on((String)"\n").withKeyValueSeparator(" => ");

    public PermissionsLogFormatter(List<Team> teams) {
        for (Team team : teams) {
            this.teamToPermissions.putAll((Object)team.getTeamName(), team.getPermissions());
        }
    }

    public ActivityLogEntry getLogEntry() {
        String text = WITH_ARROWS.join(this.teamToPermissions.asMap().entrySet());
        return ReleaseActivities.PERMISSIONS_UPDATED.create(text);
    }
}

