/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import java.util.ArrayList;
import java.util.List;

public class GateConditionsFieldsComparator {
    private GateCondition original;
    private GateCondition updated;
    private GateTask gateTask;

    public GateConditionsFieldsComparator(GateTask gateTask, GateCondition original, GateCondition updated) {
        this.original = original;
        this.updated = updated;
        this.gateTask = gateTask;
    }

    public List<ActivityLogEntry> getLogs() {
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries.add(ReleaseActivities.GATE_CONDITION_TITLE_UPDATED.create(this.updated.getTitle(), this.gateTask.getTitle(), this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.isChecked(), (Object)this.updated.isChecked())) {
            ReleaseActivities activity = this.updated.isChecked() ? ReleaseActivities.GATE_CONDITION_FULLFILLED : ReleaseActivities.GATE_CONDITION_UNFULLFILLED;
            logEntries.add(activity.create(this.updated.getTitle(), this.gateTask.getTitle()));
        }
        return logEntries;
    }
}

