/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.XLReleaseServer;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLReleaseBootstrapper {
    public static final String NAME = "XL Release";
    private static final File DEFAULT_CONFIGURATION_FILE = new File("conf", "xl-release-server.conf");
    private static final int DEFAULT_PORT = 5516;
    private final ServerLaunchOptions launchOptions;
    private final ServerConfigFile configFile;
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseBootstrapper.class);

    public XLReleaseBootstrapper(ServerLaunchOptions launchOptions, ServerConfigFile configFile) {
        this.launchOptions = launchOptions;
        this.configFile = configFile;
    }

    public static void main(String[] args) {
        ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
        if (launchOptions == null) {
            return;
        }
        new XLReleaseBootstrapper(launchOptions, new ServerConfigFile(DEFAULT_CONFIGURATION_FILE)).start();
    }

    private void start() {
        XLReleaseBootstrapper.outputReleaseInfo();
        if (this.launchOptions.isDoSetup()) {
            this.startSetup();
        } else {
            if (!this.configFile.exists()) {
                logger.error("Configuration not found...");
                this.startSetup();
            } else if (this.launchOptions.isReinitialize()) {
                logger.warn("Not re-initializing as the -setup flag is missing.");
            }
            this.startServer();
        }
    }

    private static void outputReleaseInfo() {
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        logger.info("{} version {} (built at {})", new Object[]{NAME, releaseInfo.getVersion(), releaseInfo.getDate()});
        logger.info("(c) 2012-{} XebiaLabs", (Object)new SimpleDateFormat("yyyy").format(new Date()));
        if (new Environment().isDevelopment()) {
            logger.warn(" DEVELOPMENT MODE ");
        }
    }

    private void startSetup() {
        ServerConfiguration serverDefaults = new ServerConfiguration();
        serverDefaults.setHttpPort(5516);
        Setup setupWizard = new Setup(NAME, this.configFile, this.launchOptions, serverDefaults);
        setupWizard.setAskImportablePackagesPath(false);
        setupWizard.run();
    }

    private void startServer() {
        logger.info("Starting server...");
        try {
            this.initPasswordEncryptionKey();
            XLReleasePermissions.init();
            ServerConfiguration config = this.configFile.loadConfig();
            this.checkPortAvailable(config);
            XLReleaseServer server = new XLReleaseServer(NAME, config, new Environment().getSpringConfig(), config.getWebContextRoot());
            server.getContext().addFilter(RequestLocal.class, "*", 0);
            server.start();
        }
        catch (Throwable e) {
            logger.error("Fatal error starting server", e);
        }
    }

    protected void checkPortAvailable(ServerConfiguration config) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(config.getHttpBindAddress());
        }
        catch (UnknownHostException e) {
            logger.error("Cannot start {}; invalid bind address: {}", (Object)NAME, (Object)config.getHttpBindAddress());
            System.exit(1);
        }
        if (!XLReleaseBootstrapper.isPortAvailable(config.getHttpPort(), address)) {
            logger.error("Cannot start {}; port {} already in use.", (Object)NAME, (Object)config.getHttpPort());
            logger.error("Perhaps another instance of {} is running.", (Object)NAME);
            System.exit(1);
        }
    }

    private static boolean isPortAvailable(int port, InetAddress address) {
        try {
            ServerSocket socket = new ServerSocket(port, 1, address);
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void initPasswordEncryptionKey() {
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
    }
}

