package com.xebialabs.xlrelease.plugin.manager.db

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.LiquibaseSupport
import com.xebialabs.xlrelease.spring.config.SqlConfiguration.XLR_REPOSITORY_DATA_SOURCE
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_PLUGIN_MANAGER
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}

import javax.sql.DataSource

class XlrPluginManager1031BytesColumn extends Upgrade with LiquibaseSupport with Logging{
  @Autowired
  @Qualifier(XLR_REPOSITORY_DATA_SOURCE)
  var dataSource: DataSource = _

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_PLUGIN_MANAGER, "10.3.1#0")

  override def doUpgrade(): Boolean = {
    debug("Running liquibase migration xl-plugin-manager-FI-879 for the plugin manager module.")
    doWithLiquibase("com/xebialabs/plugin/manager/db/10.3.0/xl-plugin-manager-FI-879.yaml") { liquibase =>
      liquibase.update("")
    }
    true
  }

}
