package com.xebialabs.xlrelease.plugin.manager.validator

import com.xebialabs.plugin.manager.config.impl.PluginManagerPropertiesImpl.RepositoryImpl.NexusMetadataArtifactImpl
import com.xebialabs.plugin.manager.config.impl.PluginManagerPropertiesImpl.ServerImpl.{CredentialsImpl, ProxyImpl}
import com.xebialabs.plugin.manager.config.impl.PluginManagerPropertiesImpl.{RepositoryImpl, ServerImpl}
import com.xebialabs.plugin.manager.config.{PluginManagerProperties, Repository, Server}
import org.springframework.beans.factory.annotation.Value

import java.util
import jakarta.annotation.PostConstruct
import scala.jdk.CollectionConverters._

class XlrPluginManagerProperties extends PluginManagerProperties {

  @Value("${xl.features.plugins.servers.xebialabs-plugins.server-type}")
  var serverType: String = _

  @Value("${xl.features.plugins.servers.xebialabs-plugins.url}")
  var url: String = _

  @Value("${xl.features.plugins.servers.xebialabs-plugins.credentials.username}")
  var username: String = _

  @Value("${xl.features.plugins.servers.xebialabs-plugins.credentials.password}")
  var password: String = _

  @Value("${xl.features.plugins.servers.xebialabs-plugins.proxy.host:}")
  var proxyHost: String = _

  @Value("${xl.features.plugins.servers.xebialabs-plugins.proxy.port:}")
  var proxyPort: Integer = _

  @Value("${xl.features.plugins.servers.xebialabs-plugins.proxy.credentials.username:}")
  var proxyUsername: String = _

  @Value("${xl.features.plugins.servers.xebialabs-plugins.proxy.credentials.password:}")
  var proxyPassword: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.repository-type}")
  var repositoryType: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.server-ref}")
  var serverRef: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.nexus-repository-id}")
  var nexusRepositoryId: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.nexus-group-id}")
  var nexusGroupId: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.nexus-metadata-artifact.group-id}")
  var nexusMetadataArtifactGroupId: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.nexus-metadata-artifact.artifact-id}")
  var nexusMetadataArtifactArtifactId: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.xl-component}")
  var xlComponent: String = _

  @Value("${xl.features.plugins.repositories.xlr-official.enabled}")
  var enabled: String = _

  var repository: RepositoryImpl = _
  var nexusMetadataArtifact: NexusMetadataArtifactImpl = _
  var proxy: ProxyImpl = _
  var proxyCredentials: CredentialsImpl = _
  var server: ServerImpl = _
  var serverCredentials: CredentialsImpl = _

  @PostConstruct
  def postConstruct: Unit = {
    nexusMetadataArtifact = new NexusMetadataArtifactImpl
    nexusMetadataArtifact.setArtifactId(nexusMetadataArtifactArtifactId)
    nexusMetadataArtifact.setGroupId(nexusMetadataArtifactGroupId)

    repository = new RepositoryImpl
    repository.setName("xlr-official")
    repository.setEnabled(enabled)
    repository.setNexusGroupId(nexusGroupId)
    repository.setNexusRepositoryId(nexusRepositoryId)
    repository.setRepositoryType(repositoryType)
    repository.setServerRef(serverRef)
    repository.setXlComponent(xlComponent)
    repository.setNexusMetadataArtifact(nexusMetadataArtifact)

    if (proxyUsername != null && proxyPassword != null) {
      proxyCredentials = new CredentialsImpl
      proxyCredentials.setUsername(proxyUsername)
      proxyCredentials.setPassword(proxyPassword)
    }

    if (proxyHost != null && proxyPort != null) {
      proxy = new ProxyImpl
      proxy.setHost(proxyHost)
      proxy.setPort(proxyPort)
      if (proxyCredentials != null) {
        proxy.setCredentials(proxyCredentials)
      }
    }

    serverCredentials = new CredentialsImpl
    serverCredentials.setUsername(username)
    serverCredentials.setPassword(password)

    server = new ServerImpl
    server.setName("xebialabs-plugins")
    server.setUrl(url)
    server.setServerType(serverType)
    if (proxy != null) {
      server.setProxy(proxy)
    }
    server.setCredentials(serverCredentials)
  }

  override def getRepositories: util.List[_ <: Repository] = List(repository).asJava

  override def getServers: util.List[_ <: Server] = List(server).asJava

}
