package com.xebialabs.xlrelease.plugin.manager.upgrade

import com.xebialabs.deployit.booter.local.PluginVersions
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.plugin.manager.startup.PluginUpgrader
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_PLUGIN_MANAGER
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

/**
 * This upgrade runs every time a system is upgraded cause the current version of the system is always greater than a
 * previous one. Runs regardless if the upgrade was major, minor or patch. It, however, never runs when ran inside
 * intellij via run config.
 */
@Component
class XLReleaseRepeatingPluginUpgrader @Autowired()(pluginUpgrader: PluginUpgrader) extends Upgrade with Logging {

  private lazy val xlrXlpmVersion = PluginVersions.getVersionFor(XL_RELEASE_PLUGIN_MANAGER)

  override def upgradeVersion(): Version = {
    val newVersion = if (xlrXlpmVersion.equals("@project.version@")) {
      "0.0.0"
    } else {
      xlrXlpmVersion
    }
    Version.valueOf(XL_RELEASE_PLUGIN_MANAGER, newVersion)
  }

  override def doUpgrade(): Boolean = {
    val is2410 = xlrXlpmVersion.matches("2[4-5]\\..*") // all minor releases of 2024 and 2025
    val msg = if (is2410) "Upgrading DB plugins and verifying remaining (non-upgraded) plugins for JDK17 compatibility" else "Upgrading DB plugins"
    logger.info(msg)
    val allCompatible = pluginUpgrader.upgradePlugins(is2410 && XlrConfig.getInstance.features.plugins.checkJdk17CompatibilityOnProductUpdate)
    if (!allCompatible) {
      logger.warn("Plugins incompatible with JDK17 detected, system shutting down.")
    }
    allCompatible
  }

}
