package com.xebialabs.xlrelease.plugin.manager.event

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.module.scala.DefaultScalaModule
import com.xebialabs.plugin.manager.event.{PluginInstalledEvent, PluginManagerEvent, PluginUpdatedEvent}
import com.xebialabs.xlrelease.api.internal.SystemNotificationsResource
import com.xebialabs.xlrelease.service.SseService
import org.springframework.context.event
import org.springframework.stereotype.Service

object PluginManagerEventListener {
  private val PluginInstalled = "PLUGIN_INSTALLED"
  private val PluginUpdatedEvent = "PLUGIN_UPDATED"
}

private case class Plugin(pluginName: String, restart: Boolean)

@Service
class PluginManagerEventListener(sseService: SseService) {

  private val mapper = new ObjectMapper()
  mapper.registerModule(DefaultScalaModule)

  @event.EventListener
  def onPluginManagerEvent(event: PluginManagerEvent): Unit = {
    event match {
      case PluginInstalledEvent(_, pluginName, requiresRestart) =>
        sseService.sendEvent(
          SystemNotificationsResource.SYSTEM_NOTIFICATION_SINK_ID,
          PluginManagerEventListener.PluginInstalled,
          mapper.writeValueAsString(Plugin(pluginName, requiresRestart)
          )
        )
      case PluginUpdatedEvent(_, pluginName, requiresRestart) =>
        sseService.sendEvent(
          SystemNotificationsResource.SYSTEM_NOTIFICATION_SINK_ID,
          PluginManagerEventListener.PluginUpdatedEvent,
          mapper.writeValueAsString(Plugin(pluginName, requiresRestart)
          )
        )
    }
  }
}
