package com.xebialabs.xlplatform.webhooks.events.domain

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xltype.serialization.ConfigurationItemConverter
import com.xebialabs.xltype.serialization.json.{CiJsonReader, CiJsonWriter}

import java.util.Date
import java.util.stream.Collectors
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

@Metadata(virtual = true, label = "Webhook Event")
class Event extends BaseConfigurationItem {
  @BeanProperty
  @Property(label = "Event Source", required = true)
  var sourceId: EventSource.ID = _

  @BeanProperty
  @Property(label = "Received Timestamp")
  var received: Date = _
}

object Event {

  private def converter = new ConfigurationItemConverter

  def encode(event: Event): String = {
    val writer = new CiJsonWriter()
    converter.writeCi(encrypt(event), writer, Integer.MAX_VALUE)
    writer.toString
  }

  def decode(event: String): Event = {
    val reader = CiJsonReader.create(event)
    converter.readCi(reader).asInstanceOf[Event]
  }

  // scalastyle:off cyclomatic.complexity
  def encrypt(ci: BaseConfigurationItem): BaseConfigurationItem = {
    if (ci == null) {
      null
    } else {
      ci.getType.getDescriptor.getPropertyDescriptors.asScala.foldLeft(ci) {
        case (null, _) =>
          null
        case (item, property) if property.isAsContainment =>
          item
        case (item, property) if property.getKind == PropertyKind.STRING && property.isPassword =>
          val value = item.getProperty[String](property.getName)
          item.setProperty[String](property.getName, PasswordEncrypter.getInstance().ensureEncrypted(value))
          item
        case (item, property) if property.getKind == PropertyKind.CI =>
          val value = item.getProperty[BaseConfigurationItem](property.getName)
          item.setProperty(property.getName, encrypt(value))
          item
        case (item, property) if property.getKind == PropertyKind.LIST_OF_CI  =>
          val value = item.getProperty[java.util.Collection[BaseConfigurationItem]](property.getName)
          item.setProperty(property.getName, value.stream().map(encrypt).toList)
          item
        case (item, property) if property.getKind == PropertyKind.SET_OF_CI =>
          val value = item.getProperty[java.util.Collection[BaseConfigurationItem]](property.getName)
          item.setProperty(property.getName, value.stream().map(encrypt).collect(Collectors.toSet()))
          item
        case (item, _) =>
          item
      }
    }
  }
  // scalastyle:on cyclomatic.complexity
}
