package com.xebialabs.xlrelease.webhooks.authentication

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod

@Metadata(virtual = false, label = "Scripted Authentication (Jython)")
class JythonScriptAuthentication extends BaseRequestAuthentication {
  def requestAuthentication: RequestAuthenticationMethod = JythonScriptAuthenticationMethod.getInstance()

  @Property(label = "Authentication script", required = true, category = "input", size = Property.Size.LARGE,
    description = "Jython script that will decide if an incoming request is considered authenticated. " +
      "This script should set the variable `authenticated` to either `True` or `False`. \n" +
      "The script can access the properties of the HTTP request by using the following variables: \n" +
      "* endpoint: this HTTP endpoint for Webhooks\n" +
      "* config: the HTTP endpoint's authentication method\n" +
      "* headers: the headers of the current HTTP request\n" +
      "* parameters: the URL parameters of the current HTTP request\n" +
      "* payload: the request body of the current HTTP request\n")
  var authenticationScript: String = _
}
