package com.xebialabs.xlrelease.webhooks.endpoint

import com.xebialabs.xlplatform.webhooks.domain.Endpoint
import com.xebialabs.xlplatform.webhooks.endpoint.EndpointProvider
import com.xebialabs.xlrelease.service.ConfigurationVariableService

import scala.util.Try

case class ResolvingEndpointProvider(endpointRegistry: EndpointProvider, configurationVariableService: ConfigurationVariableService) extends EndpointProvider {

  override def findEndpointByPath(path: String): Try[Endpoint] = {
    for {
      e <- endpointRegistry.findEndpointByPath(path)
      result = e match {
        case endpoint: AuthenticationWebhookEndpoint =>
          configurationVariableService.resolve(endpoint)
          endpoint
        case e => e
      }
    } yield result
  }
}
