package com.xebialabs.xlrelease.webhooks.service.script

import com.xebialabs.xlrelease.domain.ScriptHelper
import com.xebialabs.xlrelease.script.builder._
import com.xebialabs.xlrelease.script.{EncryptionHelper, XlrScript, XlrScriptContext}
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource

private abstract class BaseScriptContextBuilder(eventSource: StatusWebhookEventSource) extends ScriptContextBuilder {
  val scriptProperty: String

  final val StatusScriptProperty = "statusScript"
  final val AutoconfigScriptProperty = "autoconfigScript"
  final val PatchScriptProperty = "patchScript"
  final val CleanupScriptProperty = "cleanupScript"

  withLogger().withScriptApi()
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()

  protected def addConnectionServerAttributes(context: XlrScriptContext): Unit = {
    val sourceServer = eventSource.sourceServer
    EncryptionHelper.decrypt(sourceServer)
    context.addCiAsMap("connectionServer", sourceServer)
  }

  protected def addConnectionAttributes(context: XlrScriptContext): Unit = {
    EncryptionHelper.decrypt(eventSource)
    context.addCiAsMap("connection", eventSource)
  }

  protected def addScript(context: XlrScriptContext): Unit = {
    val script = ScriptHelper.getScript(scriptProperty, eventSource, s".$scriptProperty")
    val name = s"${eventSource.getType}[${eventSource.getTitle}-$scriptProperty]"
    context.addScript(XlrScript.byContent(name = name, content = script, wrap = false, checkPermissions = false))
  }
}
