package com.xebialabs.xlrelease.webhooks.repository.persistence

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.ItemInUseException
import com.xebialabs.xlplatform.webhooks.domain.Endpoint
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, PersistenceInterceptor}
import com.xebialabs.xlrelease.webhooks.consumers.logging.SpyConsumer
import com.xebialabs.xlrelease.webhooks.registry.SubscriberRegistry
import com.xebialabs.xlrelease.webhooks.repository.persistence.WebhookEndpointInterceptor.CiEndpoint
import org.springframework.jdbc.core.JdbcTemplate

object WebhookEndpointInterceptor {
  type CiEndpoint = BaseConfiguration with Endpoint
}

class WebhookEndpointInterceptor(configurationRepository: ConfigurationRepository,
                                 val configurationPersistence: ConfigurationPersistence,
                                 val subscriberRegistry: SubscriberRegistry,
                                 val jdbcTemplate: JdbcTemplate,
                                 val dialect: Dialect)
  extends PersistenceInterceptor[BaseConfiguration]
    with EndpointPathPersistence {
  configurationRepository.registerPersistenceInterceptor(this)

  protected lazy val protectedConsumerTypes = Set(Type.valueOf(classOf[SpyConsumer]))

  override def afterCreate(ci: BaseConfiguration): Unit = {
    ci match {
      case ci: CiEndpoint => insertEndpointPath(ci)
      case _ =>
    }
  }

  override def afterUpdate(ci: BaseConfiguration): Unit = {
    ci match {
      case ci: CiEndpoint => updateEndpointPath(ci)
      case _ =>
    }
  }

  override def onDelete(sourceId: String): Unit = {
    val consumers = subscriberRegistry.list(sourceId)
      .filterNot(consumer => protectedConsumerTypes.contains(consumer.getType))

    if (consumers.nonEmpty) {
      throw new ItemInUseException(
        s"$sourceId is referenced by ${consumers.size} consumer(s): ${consumers.map("'" + _.getId + "'").mkString("[", ", ", "]")}"
      )
    }
  }

}