package com.xebialabs.xlplatform.webhooks.domain

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventSource}

import java.util.Date
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

@Metadata(virtual = false, label = "Http Request Event")
class HttpRequestEvent extends Event {

  @BeanProperty
  @Property(label = "Source endpoint", required = true)
  var source: EventSource = _

  @BeanProperty
  @Property(label = "Request Headers")
  var headers: java.util.Map[String, String] = _

  @BeanProperty
  @Property(label = "Request Parameters")
  var parameters: java.util.Map[String, String] = _

  @BeanProperty
  @Property(label = "Request Body")
  var content: String = _

}

object HttpRequestEvent {
  def apply(source: EventSource,
            headers: java.util.Map[String, String],
            parameters: java.util.Map[String, Array[String]],
            content: String): HttpRequestEvent = {
    val event = new HttpRequestEvent
    event.sourceId = source.sourceId
    event.received = new Date()
    event.headers = headers
    event.parameters = parameters.asScala.view.mapValues(_.mkString(", ")).toMap.asJava
    event.content = content
    event
  }

}
