package com.xebialabs.xlrelease.webhooks.repository.persistence

import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.webhooks.repository.persistence.WebhookEndpointInterceptor.CiEndpoint
import com.xebialabs.xlrelease.webhooks.repository.persistence.WebhookSchema.WEBHOOK_ENDPOINTS

trait EndpointPathPersistence extends PersistenceSupport {
  def configurationPersistence: ConfigurationPersistence

  def insertEndpointPath(ci: CiEndpoint): Unit = {
    sqlInsert(s"INSERT INTO ${WEBHOOK_ENDPOINTS.TABLE} VALUES(:${WEBHOOK_ENDPOINTS.CONFIGURATION_UID}, :${WEBHOOK_ENDPOINTS.PATH})",
      paramSource(
        WEBHOOK_ENDPOINTS.CONFIGURATION_UID -> configurationPersistence.getUid(ci.getId).get,
        WEBHOOK_ENDPOINTS.PATH -> ci.path
      )
    )
  }

  def updateEndpointPath(ci: CiEndpoint): Unit = {
    val STMT_UPDATE_WEBHOOK_ENDPOINT =
      s"""UPDATE ${WEBHOOK_ENDPOINTS.TABLE}
         | SET ${WEBHOOK_ENDPOINTS.PATH} = :${WEBHOOK_ENDPOINTS.PATH}
         | WHERE ${WEBHOOK_ENDPOINTS.CONFIGURATION_UID} = :${WEBHOOK_ENDPOINTS.CONFIGURATION_UID}
         |""".stripMargin
    sqlUpdate(STMT_UPDATE_WEBHOOK_ENDPOINT, paramSource(
      WEBHOOK_ENDPOINTS.CONFIGURATION_UID -> configurationPersistence.getUid(ci.getId).get,
      WEBHOOK_ENDPOINTS.PATH -> ci.path
    ), _ => ())
  }

}
