package com.xebialabs.xlrelease.webhooks.configuration.jms;

import com.xebialabs.xlrelease.service.XlrServiceLifecycle
import com.xebialabs.xlrelease.service.XlrServiceLifecycleOrder.JMS_LISTENER
import org.springframework.jms.config.JmsListenerEndpointRegistry

import scala.jdk.CollectionConverters._


class JmsListenerLifecycleManager(registry: JmsListenerEndpointRegistry) extends XlrServiceLifecycle {

  override def getOrder: Int = JMS_LISTENER

  def doStop(): Unit = {
    registry.stop()
  }

  def doStart(): Unit = {
    // Start all JMS listeners
    // Do not use registry.start() as it will not start listeners because we start them manually and autoStart is false
    registry.getListenerContainers.asScala.foreach(_.start())
  }
}
