package com.xebialabs.xlrelease.webhooks.dispatcher

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventSource}
import com.xebialabs.xlplatform.webhooks.events.handlers.EventPublisher
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.CiIdService
import com.xebialabs.xlrelease.webhooks.repository.persistence.CiEventRecordsPersistence
import org.springframework.context.annotation.Primary
import org.springframework.security.core.context.SecurityContextHolder
import org.springframework.stereotype.Component

@Component
@Primary
class DefaultEventPublisher(ciIdService: CiIdService,
                            ciEventRecordsPersistence: CiEventRecordsPersistence,
                            otherEventPublishers: Array[EventPublisher]
                           ) extends EventPublisher {

  if (otherEventPublishers.isEmpty) {
    throw new IllegalStateException("There are no event publishers configured. Check value of configuration property 'xl.features.webhooks.event-publisher'")
  }

  override def publishEvent(eventSource: EventSource, event: Event): Boolean = {
    withNoSecurity {
      event.setId(Ids.getName(ciIdService.getUniqueId(Type.valueOf(classOf[Event]), "")))
      ciEventRecordsPersistence.insert(event)
      // since we store event 1st if we already received event we could simply ignore it
      // we could use this to implement reliable delivery even if we don't have access to message broker
      otherEventPublishers.foreach(_.publishEvent(eventSource, event))
      true
    }
  }

  private def withNoSecurity(block: => Boolean): Boolean = {
    val previousSecurityContext = SecurityContextHolder.getContext()
    try {
      SecurityContextHolder.clearContext()
      block
    } finally {
      SecurityContextHolder.setContext(previousSecurityContext)
    }
  }
}
