package com.xebialabs.xlrelease.webhooks.configuration.jms

import com.rabbitmq.jms.admin.{RMQConnectionFactory, RMQDestination}
import com.xebialabs.xlrelease.ssl.{SslContextConfig, SslContextFactory}
import grizzled.slf4j.Logging

import jakarta.jms.{ConnectionFactory, Destination}
import scala.jdk.CollectionConverters._

class RabbitWebhookJmsConfiguration(config: RabbitMqWebhookQueueConfig)
  extends BasicWebhookJmsConfiguration
    with Logging {

  override def jmsConnectionFactory: ConnectionFactory = {
    // SSL setup (amqps): https://www.rabbitmq.com/docs/ssl#java-client-connecting-with-peer-verification
    val cf = new RMQConnectionFactory()
    if (config.useSsl) {
      val sslContextConfig = SslContextConfig.fromConfig(config.sslConfig)
      // build ssl context from
      if (sslContextConfig.trustEverything) {
        cf.useSslProtocol()
      } else {
        cf.useSslProtocol(SslContextFactory.getContext(sslContextConfig))
      }
      cf.setHostnameVerification(sslContextConfig.hostnameVerification)
    }
    // if you do not want to see a warning that comes from TrustEverythingTrustManager you can use host and port instead of setUri:
    //    val brokerUri = new URI(config.url)
    //    cf.setHost(brokerUri.getHost)
    //    cf.setPort(brokerUri.getPort)
    cf.setUri(config.url)
    cf.setUsername(config.username)
    cf.setPassword(config.password)
    cf
  }


  override def webhookEventQueue: Destination = {
    val queueDeclareArguments: Map[String, AnyRef] = Map("x-queue-type" -> config.queueType)
    new RMQDestination(config.queueName, true, false, queueDeclareArguments.asJava)
  }

}
