package com.xebialabs.xlrelease.webhooks.configuration.jms

import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator
import org.springframework.boot.actuate.jms.JmsHealthIndicator
import org.springframework.boot.autoconfigure.AutoConfiguration
import org.springframework.context.annotation.Bean

import jakarta.jms.ConnectionFactory

@AutoConfiguration(after = Array(classOf[WebhookJmsConfiguration]))
@ConditionalOnEnabledHealthIndicator("jms")
class JmsHealthAutoConfiguration(cf: ConnectionFactory) {


  @Bean
  def jmsHealthIndicator: JmsHealthIndicator = new JmsHealthIndicator(cf)
}