package com.xebialabs.xlrelease.webhooks

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.webhooks.events.domain.EventSource

import scala.jdk.CollectionConverters._

package object task {
  val REACTIVE_TASK_TYPE = Type.valueOf("webhook.ReactiveTask")
  val EVENT_SOURCE_TYPE = Type.valueOf(classOf[EventSource])
  val ENDPOINT_PROPERTY = "endpoint"

  val SCRIPT_PROPERTY = "condition"
  val SCRIPT_LOCATION_PROPERTY = "webhookScriptLocation"
  val EVENT_PROPERTY = "event"

  def isImplicitReactive(taskType: Type): Boolean = {
    // if task has a property that refers to a type that produces events
    taskType.getDescriptor.getPropertyDescriptors.asScala.exists { pd =>
      val referencedType = pd.getReferencedType
      referencedType != null && referencedType.instanceOf(EVENT_SOURCE_TYPE)
    }
  }
}
