package com.xebialabs.xlrelease.webhooks.consumers.jython

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.platform.script.jython.ScriptSource
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlplatform.webhooks.events.handlers.{EventProcessorHandler, EventPublisher}
import com.xebialabs.xlrelease.config.TypedWebhookFeatureToggleCondition
import com.xebialabs.xlrelease.webhooks.utils.JythonScriptEventProcessingUtils
import grizzled.slf4j.Logging
import org.springframework.context.annotation.Conditional
import org.springframework.stereotype.Component
import org.springframework.util.ResourceUtils

import java.io.FileNotFoundException
import scala.util.Try


@Component
@Conditional(value = Array(classOf[TypedWebhookFeatureToggleCondition]))
class CustomJythonEventSourceHandler(val eventPublisher: EventPublisher,
                                     jythonScriptUtils: JythonScriptEventProcessingUtils)
  extends EventProcessorHandler[Event, Event, CustomJythonEventSource]
    with Logging {

  import jythonScriptUtils._

  override def consumerConfigType: Type = Type.valueOf(classOf[CustomJythonEventSource])

  override def filter(config: CustomJythonEventSource, event: Event): Boolean = {
    nonEmptyScriptLocation(config.filterScriptLocation).forall { path =>
      Try(ResourceUtils.getFile(path)).map { _ =>
        executeFilter(config, event, sandbox = false)
          .apply(logger)
          .apply(ScriptSource.byResource(path))
      }.recover {
        case e: FileNotFoundException =>
          logger.error("Filter caused exception, assuming false", e)
          false
      }.get
    }
  }

  override def map(config: CustomJythonEventSource, event: Event): Event = {
    val scriptSource = ScriptSource.byResource(scriptLocationOrDefault(config.getType, config.scriptLocation))
    executeMap(config, event, sandbox = false)
      .apply(logger)
      .apply(scriptSource)
  }

}
