package com.xebialabs.xlplatform.webhooks.events.handlers

import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventConsumer, EventSource}
import grizzled.slf4j.Logging

import scala.util.Try

trait EventDispatcherHandler[
  IN <: Event,
  OUT <: Event,
  C <: EventConsumer,
  H <: EventConsumerHandler[OUT, C]
] {
  self: Logging =>

  def consumers: EventSource.ID => Map[C, _ <: H]

  def dispatch(event: OUT): Unit = {
    logger.trace(s"dispatch($event) sourceId: ${event.sourceId}")
    for {
      (consumer, consumerHandler) <- consumers(event.sourceId)
      if consumer.consumerEnabled
    } {
      logger.trace(s" -> [$consumerHandler].consume($consumer, $event)")
      Try(consumerHandler.consume(consumer, event)).fold(
        t => logger.warn(s"Event consumer handler $consumerHandler failed to process $event: ${t.getMessage}", t),
        _ => ()
      )
    }
  }

}