package com.xebialabs.xlrelease.webhooks.jms

import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventSource}
import com.xebialabs.xlplatform.webhooks.events.handlers.EventSourceHandler
import com.xebialabs.xlrelease.webhooks.configuration.jms.WebhookJmsConfiguration
import grizzled.slf4j.Logging
import org.springframework.jms.core.JmsTemplate

// EventSource that publishes the incoming events to a JMS Queue
trait JmsEventPublisherHandler[E <: Event, S <: EventSource]
  extends EventSourceHandler[E, S]
    with Logging {

  def jmsTemplate: JmsTemplate

  override def publishEvent(config: S, event: E): Boolean = {
    logger.debug(s"publishEvent($config, $event)")
    jmsTemplate.convertAndSend(WebhookJmsConfiguration.WEBHOOK_EVENT_QUEUE_NAME, event)
    true
  }
}

