package com.xebialabs.xlrelease.webhooks.consumers.jython

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.platform.script.jython.ScriptSource
import com.xebialabs.xlplatform.webhooks.events.domain.Event
import com.xebialabs.xlplatform.webhooks.events.handlers.{EventProcessorHandler, EventPublisher}
import com.xebialabs.xlrelease.config.TypedWebhookFeatureToggleCondition
import com.xebialabs.xlrelease.webhooks.utils.JythonScriptEventProcessingUtils
import grizzled.slf4j.Logging
import org.springframework.context.annotation.Conditional
import org.springframework.stereotype.Component

@Component
@Conditional(value = Array(classOf[TypedWebhookFeatureToggleCondition]))
class JythonScriptEventSourceHandler(val eventPublisher: EventPublisher,
                                     jythonScriptUtils: JythonScriptEventProcessingUtils)
  extends EventProcessorHandler[Event, Event, JythonScriptEventSource]
    with Logging {

  override def consumerConfigType: Type = Type.valueOf(classOf[JythonScriptEventSource])

  import jythonScriptUtils._

  override def filter(config: JythonScriptEventSource, event: Event): Boolean = {
    Option(config.filterScript)
      .filterNot(_.isEmpty)
      .map(ScriptSource.byContent)
      .forall { script =>
        executeFilter(config, event, sandbox = true)
          .apply(logger)
          .apply(script)
      }

  }

  override def map(config: JythonScriptEventSource, event: Event): Event = {
    Option(config.mapScript)
      .filterNot(_.isEmpty)
      .map(ScriptSource.byContent)
      .flatMap { script =>
        Option {
          executeMap(config, event, sandbox = true)
            .apply(logger)
            .apply(script)
        }
      }
      .orNull
  }

}
